/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.cis;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;

public final class CisIdConverter {
    private static final String MO_REF_ID_OLD_PREFIX = "moref:";
    private static final String MO_REF_ID_PREFIX = "urn:vmomi:";
    private static final String CIS_ID_TEMPLATE = "urn:vmomi:%s:%s:%s";

    private CisIdConverter() {
    }

    @Deprecated
    public static String toCisId(ManagedObjectReference moRef, String serverGuid) {
        if (moRef == null || serverGuid == null) {
            throw new IllegalArgumentException("moRef or serverGuid is null");
        }
        if (moRef.getType() == null || moRef.getValue() == null) {
            throw new IllegalArgumentException("moRef.getType() or .getValue() is null");
        }
        return String.format(CIS_ID_TEMPLATE, moRef.getType(), moRef.getValue(), serverGuid);
    }

    @Deprecated
    public static ManagedObjectReference fromCisId(String cisId) {
        String stripped;
        if (cisId == null) {
            throw new IllegalArgumentException("cisId is null");
        }
        if (cisId.startsWith(MO_REF_ID_PREFIX)) {
            stripped = cisId.substring(MO_REF_ID_PREFIX.length());
        } else if (cisId.startsWith(MO_REF_ID_OLD_PREFIX)) {
            stripped = cisId.substring(MO_REF_ID_OLD_PREFIX.length());
        } else {
            throw new IllegalArgumentException(String.format("cisId has wrong format: %s", cisId));
        }
        String[] tokens = stripped.split(":");
        if (tokens.length != 3) {
            throw new IllegalArgumentException(String.format("cisId has wrong format: %s", cisId));
        }
        return new ManagedObjectReference(tokens[0], tokens[1], tokens[2]);
    }

    public static String toGlobalCisId(ManagedObjectReference moRef, String serverGuid) {
        if (moRef == null || serverGuid == null) {
            throw new IllegalArgumentException("moRef or serverGuid is null");
        }
        if (moRef.getValue() == null) {
            throw new IllegalArgumentException("moRef.getValue() is null");
        }
        return moRef.getValue() + ":" + serverGuid;
    }

    public static ManagedObjectReference fromGlobalCisId(String cisId, String moType) {
        if (cisId == null || moType == null) {
            throw new IllegalArgumentException("cisId or moType is null");
        }
        String[] tokens = cisId.split(":");
        if (tokens.length != 2) {
            throw new IllegalArgumentException(String.format("cisId has wrong format: %s", cisId));
        }
        return new ManagedObjectReference(moType, tokens[0], tokens[1]);
    }
}

