/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.data.RemoteLoginData;
import com.vmware.srm.client.infrastructure.commonData.StringDrData;
import com.vmware.srm.client.infrastructure.health.HealthData;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.init.workflow.Status;
import com.vmware.srm.client.infrastructure.oauth2.OAuth2VapiUtils;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.context.GetTopology;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.http.AsyncHttpUtils;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.srm.client.topology.impl.view.availability.hms.HmsPairSetupImpl;
import com.vmware.srm.client.topology.impl.view.availability.srm.SrmPairSetupImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.vim.binding.dr.SessionManager;
import com.vmware.vim.binding.hms.SessionManager;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.UriComponentsBuilder;

@DrInputType(value=RemoteLoginData.class)
public class RemoteLoginDataHandler
implements FreeRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginDataHandler.class);
    private static final String REMOTE_LOGIN_REQUEST_PATH = "/remotelogin/oauth2/request";
    private static final String RESPONSE_TOKEN_PATH = "/remotelogin/responsetoken";
    private final SrmHelper _srmHelper = new SrmHelper();
    private final HmsHelper _hmsHelper = new HmsHelper();

    @Override
    public Promise<? extends DrData> handle(DrData input, FreeRequestContext context) {
        RemoteLoginData loginData = (RemoteLoginData)input;
        ExtensionServersView view = (ExtensionServersView)context.view();
        String uiHostFromBrowser = loginData.getUiHostnameInBrowser();
        Promise srmRequest = null;
        Promise<HelperResult> hmsRequest = null;
        if (loginData.getSrmGuid() != null) {
            srmRequest = this.createSrmAuthRequest(view, loginData.getSrmGuid(), loginData.getRemoteSrmGuid(), uiHostFromBrowser);
        }
        if (loginData.getHmsGuid() != null) {
            hmsRequest = this.createHmsAuthRequest(view, loginData.getHmsGuid(), loginData.getRemoteHmsGuid(), uiHostFromBrowser);
        }
        Promise result = srmRequest != null && hmsRequest != null ? Promises.anyOf((Promise[])new Promise[]{srmRequest, hmsRequest}) : (srmRequest != null ? srmRequest : (Promise)Objects.requireNonNull(hmsRequest));
        return result.thenApply(helperResult -> {
            String requestId;
            Topology topology = ((GetTopology)((Object)context)).get();
            topology.setRemoteLoginServer(helperResult.authRequest, new Topology.RemoteLoginServerData(helperResult.pairSetup.pairServerGuid(), loginData.getUiCurrentLocation()));
            try {
                requestId = URLEncoder.encode(helperResult.authRequest, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            String redirect = UriComponentsBuilder.fromUri((URI)helperResult.remoteUiUri).queryParam("requestid", new Object[]{requestId}).build(true).toUriString();
            return new StringDrData(redirect);
        });
    }

    private Promise<HelperResult> createSrmAuthRequest(ExtensionServersView view, String srmGuid, String pairSrmGuid, String uiHostNameFromBrowser) {
        Promise psPromise = this.findPair(view, srmGuid, pairSrmGuid);
        return psPromise.thenCompose(pairSetup -> this._srmHelper.process(pairSetup, uiHostNameFromBrowser));
    }

    private Promise<HelperResult> createHmsAuthRequest(ExtensionServersView view, String hmsGuid, String pairHmsGuid, String uiHostNameFromBrowser) {
        Promise psPromise = this.findPair(view, hmsGuid, pairHmsGuid);
        return psPromise.thenCompose(pairSetup -> this._hmsHelper.process(pairSetup, uiHostNameFromBrowser));
    }

    private <T extends PairSetupImpl<?>> Promise<T> findPair(ExtensionServersView view, String serverGuid, String pairServerGuid) {
        return view.getServerBy(pairServerGuid).materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                LOGGER.warn("Already authenticated in remote server {}", (Object)pairServerGuid);
                return Promises.reject((Exception)new RuntimeException(L10N.localize("noEligiblePairSetup", pairServerGuid)));
            }
            if (pr.getError() instanceof ExtensionServersView.ServerByPairSetupException) {
                ExtensionServersView.ServerByPairSetupException sbpsExc = (ExtensionServersView.ServerByPairSetupException)pr.getError();
                PairSetupImpl pairSetup = sbpsExc.getPairSetups().stream().filter(ps -> ps.server().guid().equals(serverGuid) && ps.pairServerGuid().equals(pairServerGuid)).findFirst().orElse(null);
                if (pairSetup == null) {
                    return Promises.reject((Exception)new RuntimeException(L10N.localize("noEligiblePairSetup", pairServerGuid)));
                }
                Exception cause = sbpsExc.getCause((PairSetup)pairSetup);
                if (!(cause instanceof NotAuthenticated)) {
                    return Promises.reject((Exception)new RuntimeException(L10N.localize("noEligiblePairSetup", pairServerGuid), cause));
                }
                return Promises.resolve((Object)pairSetup);
            }
            return Promises.reject((Exception)pr.getError());
        });
    }

    private static class SrmHelper
    extends RemoteLoginHelper<SrmServer, SrmPairSetupImpl> {
        private SrmHelper() {
        }

        @Override
        Promise<LsppServiceEndpoint> getVmomiEndpoint(URI lsppUrl, String thumbprint, String pairServerGuid) {
            return OAuth2VapiUtils.getSrmByGuid(lsppUrl, thumbprint, pairServerGuid).thenApply(srmReg -> LsppHelper.getVmomiEndpoint((LsppService)srmReg, (String)"com.vmware.dr.vcDr")).thenApply(ep -> Objects.requireNonNull(ep, "No vmomi endpoint for srm " + pairServerGuid));
        }

        @Override
        Promise<String> createAuthRequest(SrmServer server, ManagedObjectReference remoteSiteRef, URI localEndpoint) {
            return ((SrmService)server.service()).getContent().thenCompose(content -> {
                SessionManager sm = (SessionManager)((SrmService)server.service()).createStub(content.getSessionManager());
                SessionManager.PeerAuthRequestSpec spec = new SessionManager.PeerAuthRequestSpec();
                spec.setAuthResponseEndpoint(localEndpoint.toString());
                FuturePromise result = new FuturePromise();
                sm.createPeerAuthRequest(remoteSiteRef, spec, (Future)result);
                return result.onSuccess(code -> LOGGER.info("Received code {} from {}", code, (Object)server.service()));
            });
        }
    }

    private static class HmsHelper
    extends RemoteLoginHelper<HmsServer, HmsPairSetupImpl> {
        private HmsHelper() {
        }

        @Override
        Promise<LsppServiceEndpoint> getVmomiEndpoint(URI lsppUrl, String thumbprint, String pairServerGuid) {
            return OAuth2VapiUtils.getHmsByGuid(lsppUrl, thumbprint, pairServerGuid).thenApply(hmsReg -> LsppHelper.getVmomiEndpoint((LsppService)hmsReg, (String)"com.vmware.vim.hms")).thenApply(ep -> Objects.requireNonNull(ep, "No vmomi endpoint for hms " + pairServerGuid));
        }

        @Override
        Promise<String> createAuthRequest(HmsServer server, ManagedObjectReference remoteSiteRef, URI localEndpoint) {
            return ((HmsService)server.service()).getContent().thenCompose(content -> {
                com.vmware.vim.binding.hms.SessionManager sm = (com.vmware.vim.binding.hms.SessionManager)((HmsService)server.service()).createStub(content.getSessionManager());
                SessionManager.PeerAuthRequestSpec spec = new SessionManager.PeerAuthRequestSpec();
                spec.setAuthResponseEndpoint(localEndpoint.toString());
                FuturePromise result = new FuturePromise();
                sm.createPeerAuthRequest(remoteSiteRef, spec, (Future)result);
                return result.onSuccess(code -> LOGGER.info("Received code {} from {}", code, (Object)server.service()));
            });
        }
    }

    private static class HelperResult {
        final PairSetupImpl<?> pairSetup;
        final String authRequest;
        final URI remoteUiUri;

        HelperResult(PairSetupImpl<?> pairSetup, String authRequest, URI remoteUiUri) {
            this.pairSetup = pairSetup;
            this.authRequest = authRequest;
            this.remoteUiUri = remoteUiUri;
        }
    }

    static abstract class RemoteLoginHelper<S extends ExtensionServer<?>, T extends PairSetupImpl<S>> {
        RemoteLoginHelper() {
        }

        final Promise<HelperResult> process(T pairSetup, String uiHostNameFromBrowser) {
            URI responseUrl;
            try {
                responseUrl = Config.getAppBaseUrl((String)"https", (String)uiHostNameFromBrowser, (int)Config.get().getAppUrl().getPort(), (String)"/dr/remotelogin/responsetoken");
            }
            catch (URISyntaxException e) {
                LOGGER.warn("Failed to create redirect uri", (Throwable)e);
                return Promises.reject((Exception)e);
            }
            Promise<String> authRequest = this.createAuthRequest(pairSetup.server(), pairSetup.pairServerVmomiRef(), responseUrl);
            Promise remoteUiRedirect = this.getVmomiEndpoint(pairSetup.pairLsppUrl(), pairSetup.pairLsppThumbprint(), pairSetup.pairServerGuid()).thenCompose(ep -> {
                KeyStore trustStore;
                try {
                    trustStore = CertificateUtils.createTrustStore((Collection)ep.getCertificates());
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed to create trust store for {}", ep, (Object)exc);
                    return Promises.reject((Exception)exc);
                }
                trustStore = (KeyStore)SslTrust.get((KeyStore)trustStore).second();
                return this.checkUiHealth(ep.url, trustStore).thenApply(health -> {
                    if (health.getStatus() != Status.OK.get()) {
                        LOGGER.warn("Remote UI health for server at {} is not OK: {}", (Object)ep.url, (Object)health.getMsg());
                        throw new RuntimeException(health.getMsg());
                    }
                    try {
                        return Config.getAppBaseUrl((String)ep.url.getScheme(), (String)ep.url.getHost(), (int)Config.get().getAppUrl().getPort(), (String)"/dr/remotelogin/oauth2/request");
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                });
            });
            return authRequest.thenCombine(remoteUiRedirect, (authReq, redirectUri) -> new HelperResult((PairSetupImpl<?>)pairSetup, (String)authReq, (URI)redirectUri));
        }

        private Promise<HealthData> checkUiHealth(URI remoteServerUrl, KeyStore trustStore) {
            URI remoteUiUri;
            try {
                remoteUiUri = Config.createAppUrl((String)remoteServerUrl.getHost(), (int)443);
            }
            catch (URISyntaxException e) {
                return Promises.reject((Exception)e);
            }
            return AsyncHttpUtils.doGet((URI)remoteUiUri.resolve("/dr/health"), (KeyStore)trustStore, null).thenCompose(response -> {
                byte[] content;
                HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
                if (status.series() == HttpStatus.Series.CLIENT_ERROR || status.series() == HttpStatus.Series.SERVER_ERROR) {
                    LOGGER.warn("Http error getting remote UI health for server at {}:{}", (Object)remoteServerUrl, (Object)response.getStatusLine());
                    return Promises.reject((Exception)new RuntimeException("Unable to get remote UI server health: " + String.valueOf(response.getStatusLine())));
                }
                try {
                    content = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                }
                catch (Exception e) {
                    return Promises.reject((Exception)e);
                }
                if (content == null) {
                    return Promises.reject((Exception)new RuntimeException("No content in response."));
                }
                try {
                    return Promises.resolve((Object)SerializationUtil.fromByteArray(content, HealthData.class));
                }
                catch (IOException e) {
                    return Promises.reject((Exception)e);
                }
            });
        }

        abstract Promise<LsppServiceEndpoint> getVmomiEndpoint(URI var1, String var2, String var3);

        abstract Promise<String> createAuthRequest(S var1, ManagedObjectReference var2, URI var3);
    }
}

