/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.http.io.HttpResponseController;
import com.vmware.srm.client.infrastructure.vapi.AsyncCallbackPromise;
import com.vmware.srm.client.infrastructure.vapi.VapiServiceImpl;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.http.AsyncHttpUtils;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vcenter.tokenservice.TokenExchange;
import com.vmware.vcenter.tokenservice.TokenExchangeTypes;
import com.vmware.vim.sso.client.DefaultTokenFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2AuthenticationUtils {
    private static final String AUTH_HEADER_NAME = "Authorization";
    public static final String CODE_PARAM = "code";
    public static final String GRAND_TYPE_PARAM = "grant_type";
    public static final String AUTH_CODE_GRAND_TYPE_PARAM_VALUE = "authorization_code";
    public static final String REFRESH_TOKEN_GRAND_TYPE_PARAM_VALUE = "refresh_token";
    public static final String APP_REDIRECT_URL_PARAM = "redirect_uri";
    public static final String REFRESH_TOKEN_PARAM = "refresh_token";

    static String createAuthHeader(String clientId, String clientSecret) {
        String up = clientId + ":" + clientSecret;
        return "Basic " + Base64.getEncoder().encodeToString(up.getBytes(StandardCharsets.UTF_8));
    }

    public static Promise<OAuth2TokenResponse> exchangeAuthCodeForJwtToken(String code, URI tokenEndpoint, String clientId, String clientSecret, URI appRedirectUrl, Map<String, List<String>> queryParams) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(CODE_PARAM, code));
        params.add(new BasicNameValuePair(GRAND_TYPE_PARAM, AUTH_CODE_GRAND_TYPE_PARAM_VALUE));
        params.add(new BasicNameValuePair(APP_REDIRECT_URL_PARAM, appRedirectUrl.toString()));
        return OAuth2AuthenticationUtils.executeJwtTokenOp(tokenEndpoint, clientId, clientSecret, queryParams, params);
    }

    public static Promise<OAuth2TokenResponse> refreshJwtToken(URI tokenEndpoint, String clientId, String clientSecret, String refreshToken, Map<String, List<String>> queryParams) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(GRAND_TYPE_PARAM, "refresh_token"));
        params.add(new BasicNameValuePair("refresh_token", refreshToken));
        return OAuth2AuthenticationUtils.executeJwtTokenOp(tokenEndpoint, clientId, clientSecret, queryParams, params);
    }

    private static Promise<OAuth2TokenResponse> executeJwtTokenOp(URI tokenEndpoint, String clientId, String clientSecret, Map<String, List<String>> queryParams, List<BasicNameValuePair> formParams) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)tokenEndpoint);
        for (Map.Entry<String, List<String>> e : queryParams.entrySet()) {
            uriBuilder = uriBuilder.queryParam(e.getKey(), (Collection)e.getValue());
        }
        HttpPost post = new HttpPost(uriBuilder.toUriString());
        post.addHeader(AUTH_HEADER_NAME, OAuth2AuthenticationUtils.createAuthHeader(clientId, clientSecret));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        URI proxyHost = Config.get().getHttpProxy();
        if (proxyHost != null) {
            post.setConfig(AsyncHttpUtils.createRequestConfig((URI)proxyHost));
        }
        try {
            return HttpResponseController.doPost(post, SslTrust.getTrustStore(), null).thenApply(response -> {
                byte[] content;
                HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
                if (status.series() == HttpStatus.Series.CLIENT_ERROR || status.series() == HttpStatus.Series.SERVER_ERROR) {
                    throw new RuntimeException("Failed to execute token op: " + String.valueOf(response.getStatusLine()));
                }
                try {
                    content = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (content == null) {
                    throw new RuntimeException("No content in response.");
                }
                try {
                    return SerializationUtil.fromByteArray(content, OAuth2TokenResponse.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
    }

    public static Promise<SamlToken> exchangeJwtForSamlToken(LsppServiceEndpoint vapiEp, SsoContext ssoContext, String jwtToken, String idToken) {
        return OAuth2AuthenticationUtils.exchangeJwtForSamlToken(vapiEp, ssoContext.getSolutionUserTokenProvider(), jwtToken, idToken).thenApply(tokenInfo -> {
            String decodedToken = new String(Base64.getDecoder().decode(tokenInfo.getAccessToken()));
            try {
                return DefaultTokenFactory.createToken((String)decodedToken, (X509Certificate[])ssoContext.getSigningCerts(), (long)ssoContext.getClockTolerance());
            }
            catch (InvalidTokenException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
        });
    }

    private static Promise<TokenExchangeTypes.Info> exchangeJwtForSamlToken(LsppServiceEndpoint vapiEp, TokenProvider suTokenProvider, String jwtToken, String idToken) {
        KeyStore sslStore;
        try {
            sslStore = CertificateUtils.createTrustStore((Collection)vapiEp.getCertificates());
        }
        catch (Exception e) {
            return Promises.reject((Exception)e);
        }
        return OAuth2AuthenticationUtils.exchangeJwtForSamlToken(vapiEp.url, sslStore, suTokenProvider, jwtToken, idToken);
    }

    private static Promise<TokenExchangeTypes.Info> exchangeJwtForSamlToken(URI vapiUrl, KeyStore vapiSslStore, TokenProvider suTokenProvider, String jwtToken, String idToken) {
        int socketTimeout;
        int connectTimeout;
        try {
            connectTimeout = (int)Config.get().getConnectTimeout();
            socketTimeout = (int)Config.get().getSocketTimeout();
        }
        catch (Exception exc) {
            return Promises.reject((Exception)exc);
        }
        VapiServiceImpl service = new VapiServiceImpl(vapiUrl, vapiSslStore, connectTimeout, socketTimeout);
        TokenExchange tokenExchange = service.createStub(TokenExchange.class);
        AsyncCallbackPromise result = new AsyncCallbackPromise();
        result.materialize().onSuccess(unused -> service.dispose());
        TokenExchangeTypes.ExchangeSpec spec = new TokenExchangeTypes.ExchangeSpec();
        spec.setGrantType("urn:ietf:params:oauth:grant-type:token-exchange");
        spec.setSubjectToken(jwtToken);
        spec.setSubjectTokenType("urn:ietf:params:oauth:token-type:access_token");
        spec.setActorToken(idToken);
        spec.setActorTokenType("urn:ietf:params:oauth:token-type:id_token");
        spec.setRequestedTokenType("urn:ietf:params:oauth:token-type:saml2");
        return suTokenProvider.createSecurityContext().thenCompose(sc -> {
            ExecutionContext ec = new ExecutionContext(sc);
            tokenExchange.exchange(spec, (AsyncCallback)result, new InvocationConfig(ec));
            return result;
        });
    }

    public static final class OAuth2TokenResponse {
        @JsonProperty(value="access_token")
        public String accessToken;
        @JsonProperty(value="refresh_token")
        public String refreshToken;
        @JsonProperty(value="id_token")
        public String idToken;
        @JsonProperty(value="token_type")
        public String tokenType;
        @JsonProperty(value="expires_in")
        public int expiresIn;
        @JsonProperty(value="scope")
        public String scope;
    }
}

