/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.infrastructure.http.HttpUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAsyncController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAsyncController.class);
    private static final long DEFAULT_RESPONSE_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    protected final HttpServletRequest _request;
    protected final HttpServletResponse _response;

    public static void sendInternalServerError(Exception unused, HttpServletResponse response) {
        try {
            response.sendError(500);
        }
        catch (IOException e) {
            LOGGER.error("Failed to send response to client.", (Throwable)e);
        }
    }

    public BaseAsyncController(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
    }

    private Stream<HttpProcessStage> buildPipeline(HttpProcessStage stage) {
        return stage.process().flatMap(this::buildPipeline);
    }

    private Stream<HttpProcessStage> buildPipeline() {
        HttpProcessStage stage;
        try {
            stage = this.createPipeline();
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to create initial stage for request '{}'", (Object)HttpUtils.getPath(this._request), (Object)t);
            return Promises.reject((Exception)Exceptions.wrap((Throwable)t)).toStream();
        }
        return Streams.just((Object[])new HttpProcessStage[]{stage}).flatMap(this::buildPipeline);
    }

    protected abstract HttpProcessStage createPipeline();

    public Promise<Void> start() throws IOException {
        return this.start(DEFAULT_RESPONSE_TIMEOUT);
    }

    public final Promise<Void> start(long timeout) throws IOException {
        AsyncContext context = this._request.startAsync();
        context.setTimeout(timeout);
        String path = HttpUtils.getPath(this._request);
        context.addListener((AsyncListener)new ContextListener(path));
        return this.buildPipeline().collect().onSuccess(unused -> context.complete()).onError(exc -> {
            LOGGER.warn("Request for path '{}' failed.", (Object)path, exc);
            try {
                BaseAsyncController.sendInternalServerError(exc, this._response);
            }
            finally {
                context.complete();
            }
        }).thenApply(unused -> null);
    }

    public static interface HttpProcessStage {
        public Stream<HttpProcessStage> process();
    }

    private static final class ContextListener
    implements AsyncListener {
        private final String _path;

        ContextListener(String path) {
            this._path = path;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            LOGGER.debug("Processing of request to '{}' completed", (Object)this._path);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            LOGGER.error("Processing of request to '{}' timed out", (Object)this._path);
        }

        public void onError(AsyncEvent event) throws IOException {
            LOGGER.error("Error occurred while processing of request to {}", (Object)this._path, (Object)event.getThrowable());
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            LOGGER.debug("Processing of request to '{}' started", (Object)this._path);
        }
    }
}

