/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.oauth2.remotelogin;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.oauth2.remotelogin.RemoteLoginRequestVerifier;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.hms.HmsServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.srm.SrmServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.version.VersionUtils;
import com.vmware.vim.binding.dr.SessionManager;
import com.vmware.vim.binding.hms.version.version18;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Objects;

public class RemoteLoginVerifiers {
    public static RemoteLoginRequestVerifier createRequestVerifier(LsppService lsppReg, SsoContext ssoContext) {
        Objects.requireNonNull(lsppReg, "lsppReg");
        Objects.requireNonNull(ssoContext);
        switch (lsppReg.getServiceType()) {
            case Srm: {
                return RemoteLoginVerifiers.createSrmVerifier(lsppReg, ssoContext.getSolutionUserTokenProvider());
            }
            case Hms: {
                return RemoteLoginVerifiers.createHmsVerifier(lsppReg, ssoContext.getSolutionUserTokenProvider());
            }
        }
        throw new IllegalArgumentException("Unsupported server type: " + String.valueOf(lsppReg.getServiceType()));
    }

    private static SrmRemoteLoginVerifier createSrmVerifier(LsppService srmReg, TokenProvider tokenProvider) {
        KeyStore store;
        LsppServiceEndpoint vmomiEp = Objects.requireNonNull(LsppHelper.getVmomiEndpoint((LsppService)srmReg, (String)"com.vmware.dr.vcDr"), "No srm vmomi endpoint");
        try {
            store = CertificateUtils.createTrustStore((Collection)vmomiEp.getCertificates());
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        SrmServiceImpl srmService = new SrmServiceImpl(vmomiEp.url, store, tokenProvider, srmReg.getAttributes().getOrDefault("supportedVmodlVersions", "/vcdr/vmomi/drserviceversions.xml"));
        return new SrmRemoteLoginVerifier(srmService);
    }

    private static HmsRemoteLoginVerifier createHmsVerifier(LsppService hmsReg, TokenProvider tokenProvider) {
        KeyStore store;
        LsppServiceEndpoint vmomiEp = Objects.requireNonNull(LsppHelper.getVmomiEndpoint((LsppService)hmsReg, (String)"com.vmware.vim.hms"), "No hms vmomi endpoint");
        try {
            store = CertificateUtils.createTrustStore((Collection)vmomiEp.getCertificates());
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException((Throwable)e);
        }
        return new HmsRemoteLoginVerifier(new HmsServiceImpl(vmomiEp.url, store, tokenProvider));
    }

    private static class SrmRemoteLoginVerifier
    implements RemoteLoginRequestVerifier {
        private static final Class<? extends Annotation> MIN_SUPPORTED_VERSION_CLASS = com.vmware.vim.binding.dr.version.version18.class;
        private static final VmodlVersion MIN_VLSI_VERSION = VersionUtils.getSrmVmodlVersion(MIN_SUPPORTED_VERSION_CLASS);
        private final SrmServiceImpl _service;

        private SrmRemoteLoginVerifier(SrmServiceImpl service) {
            this._service = service;
        }

        @Override
        public Promise<RemoteLoginRequestVerifier.RequestSpec> verify(String requestUuid) {
            Promise<Boolean> isSupportedPromise = this.isSupported();
            return this._service.getContent().thenCombineCompose(isSupportedPromise, (content, supported) -> {
                if (!supported.booleanValue()) {
                    return Promises.reject((Exception)new UnsupportedOperationException("Remote login is not supported."));
                }
                SessionManager sm = (SessionManager)this._service.createStub(content.getSessionManager());
                return this._service.getTokenProvider().createLoginStub((ManagedObject)sm);
            }).thenCompose(sm -> {
                FuturePromise result = new FuturePromise();
                sm.getAuthRequest(requestUuid, (Future)result);
                return result;
            }).thenApply(authSpec -> new RemoteLoginRequestVerifier.RequestSpec(authSpec.getAuthResponseEndpoint(), authSpec.getNoPrompt(), authSpec.getUsername()));
        }

        @Override
        public Promise<Boolean> isSupported() {
            return this._service.getVersion().thenApply(serviceVersion -> VersionUtils.isCompatible((VmodlVersion)serviceVersion, (VmodlVersion)MIN_VLSI_VERSION));
        }
    }

    private static class HmsRemoteLoginVerifier
    implements RemoteLoginRequestVerifier {
        private static final Class<? extends Annotation> MIN_SUPPORTED_VERSION_CLASS = version18.class;
        private static final VmodlVersion MIN_VLSI_VERSION = VersionUtils.getHmsVmodlVersion(MIN_SUPPORTED_VERSION_CLASS);
        private final HmsServiceImpl _service;

        private HmsRemoteLoginVerifier(HmsServiceImpl service) {
            this._service = service;
        }

        @Override
        public Promise<RemoteLoginRequestVerifier.RequestSpec> verify(String requestUuid) {
            Promise<Boolean> isSupportedPromise = this.isSupported();
            return this._service.getContent().thenCombineCompose(isSupportedPromise, (content, supported) -> {
                if (!supported.booleanValue()) {
                    return Promises.reject((Exception)new UnsupportedOperationException("Remote login is not supported."));
                }
                com.vmware.vim.binding.hms.SessionManager sm = (com.vmware.vim.binding.hms.SessionManager)this._service.createStub(content.getSessionManager());
                return this._service.getTokenProvider().createLoginStub((ManagedObject)sm);
            }).thenCompose(sm -> {
                FuturePromise result = new FuturePromise();
                sm.getAuthRequest(requestUuid, (Future)result);
                return result;
            }).thenApply(authSpec -> new RemoteLoginRequestVerifier.RequestSpec(authSpec.getAuthResponseEndpoint(), authSpec.getNoPrompt(), authSpec.getUsername()));
        }

        @Override
        public Promise<Boolean> isSupported() {
            return this._service.getVersion().thenApply(serviceVersion -> VersionUtils.isCompatible((VmodlVersion)serviceVersion, (VmodlVersion)MIN_VLSI_VERSION));
        }
    }
}

