/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.requestHandlers.impl;

import com.vmware.dr.ui.tools.utilities.CachingProducer;
import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.infrastructure.requestHandlers.DrRequestHandler;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandlersLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHandlersLookup.class);
    private final CacheImpl _cache;

    public static RequestHandlersLookup create(ServletConfig config) {
        return new RequestHandlersLookup(config);
    }

    private RequestHandlersLookup(ServletConfig config) {
        HashSet<Key> keys = new HashSet<Key>();
        Enumeration paramNamesEnum = config.getInitParameterNames();
        while (paramNamesEnum.hasMoreElements()) {
            Class<?> clazz;
            String paramName;
            String path = paramName = (String)paramNamesEnum.nextElement();
            String className = config.getInitParameter(path);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Request handler cannot be loaded: ", (Throwable)e);
                continue;
            }
            keys.add(new Key(path, clazz));
        }
        this._cache = new CacheImpl(keys);
    }

    public DrRequestHandler<?> get(String path) {
        try {
            return (DrRequestHandler)this._cache.get(new Key(path));
        }
        catch (Exception e) {
            LOGGER.error("Unable to get request handler", (Throwable)e);
            return null;
        }
    }

    private static final class Key {
        final String path;
        final Class<? extends DrRequestHandler<?>> handlerClass;
        private Integer _hash;

        Key(String path) {
            this(path, null);
        }

        Key(String path, Class<? extends DrRequestHandler<?>> handlerClass) {
            this.path = path;
            this.handlerClass = handlerClass;
        }

        public int hashCode() {
            if (this._hash == null) {
                this._hash = HashUtils.getHashCode((Object[])new Object[]{this.path});
            }
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return HashUtils.areEqual((Object)this.path, (Object)other.path);
        }

        public String toString() {
            HashMap<String, String> members = new HashMap<String, String>();
            members.put("path", this.path);
            return StringUtils.getToStringValue((String)"RequestHandlersLookup.Key", members);
        }
    }

    private static final class CacheImpl
    extends CachingProducer<Key, DrRequestHandler<?>> {
        CacheImpl(Set<Key> keys) {
            super(keys);
        }

        protected DrRequestHandler<?> produce(Key key) throws Exception {
            return key.handlerClass.newInstance();
        }
    }
}

