/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.IDPConfigurationFactory;
import com.vmware.identity.websso.client.SingleLogoutService;
import com.vmware.identity.websso.client.SingleSignOnService;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.Validate;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class IDPConfigParser {
    IDPConfigParser() {
    }

    private static List<Node> getChildren(Node parent, String namespace, String localName, boolean checkNotEmpty) {
        NodeList nodes;
        if (parent instanceof Document) {
            nodes = ((Document)parent).getElementsByTagNameNS(namespace, localName);
        } else if (parent instanceof Element) {
            nodes = ((Element)parent).getElementsByTagNameNS(namespace, localName);
        } else {
            throw new IllegalArgumentException("parent: " + String.valueOf(parent));
        }
        if (nodes.getLength() == 0 && checkNotEmpty) {
            throw new RuntimeException("No '" + localName + "' elements found.");
        }
        return Collections.list(new EnumImpl(nodes));
    }

    private static List<Node> getChildren(Node parent, String namespace, String localName) {
        return IDPConfigParser.getChildren(parent, namespace, localName, true);
    }

    IDPConfiguration create(Document doc) throws ParseException, CertificateException, UnsupportedEncodingException, DOMException {
        Element entityDescriptor = this.getEntityDescriptorNode(doc);
        this.checkIfExpired(entityDescriptor);
        Element idpSSODescriptor = this.getIDPSSODescriptor(entityDescriptor);
        String entityID = entityDescriptor.getAttribute("entityID");
        Element signingKeyDescriptor = this.getSigningKeyDescriptor(idpSSODescriptor);
        Element keyInfo = this.getKeyInfo(signingKeyDescriptor);
        List<X509Certificate> certificates = this.parseCertificates(keyInfo);
        List<String> nameIDFormats = this.parseNameIDFormats(idpSSODescriptor);
        List<SingleSignOnService> ssos = this.parseSsoServices(idpSSODescriptor);
        List<SingleLogoutService> slos = this.parseSloServices(idpSSODescriptor);
        return IDPConfigurationFactory.createIDPConfigurationWithoutSiteAffinity((String)entityID, (String)entityID, (X509Certificate)certificates.get(0), nameIDFormats, ssos, slos);
    }

    private Element getEntityDescriptorNode(Document doc) {
        return (Element)IDPConfigParser.getChildren(doc, "urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor").get(0);
    }

    private Element getIDPSSODescriptor(Element entityDescriptor) {
        return (Element)IDPConfigParser.getChildren(entityDescriptor, "urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor").get(0);
    }

    private Element getSigningKeyDescriptor(Element idpSSODescriptor) {
        List<Node> keyDescriptors = IDPConfigParser.getChildren(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor");
        for (int i = 0; i < keyDescriptors.size(); ++i) {
            Element element = (Element)keyDescriptors.get(i);
            if (!"signing".equals(element.getAttribute("use"))) continue;
            return element;
        }
        throw new RuntimeException("No signing 'KeyDescriptor' element found.");
    }

    private Element getKeyInfo(Element keyDescriptor) {
        List<Node> nodes = IDPConfigParser.getChildren(keyDescriptor, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        return (Element)nodes.get(0);
    }

    private List<X509Certificate> parseCertificates(Element keyInfo) throws CertificateException, UnsupportedEncodingException, DOMException {
        List<Node> nodes = IDPConfigParser.getChildren(keyInfo, "http://www.w3.org/2000/09/xmldsig#", "X509Data");
        List<Node> certNodes = IDPConfigParser.getChildren(nodes.get(0), "http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certNodes.size());
        for (Node node : certNodes) {
            result.add((X509Certificate)CertificateUtils.getCertificate((String)node.getTextContent()));
        }
        return result;
    }

    private List<String> parseNameIDFormats(Element idpSSODescriptor) {
        List<Node> nodes = IDPConfigParser.getChildren(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat", false);
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            result.add(node.getTextContent());
        }
        return result;
    }

    private List<SingleSignOnService> parseSsoServices(Element idpSSODescriptor) {
        List<Node> nodes = IDPConfigParser.getChildren(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService");
        ArrayList<SingleSignOnService> result = new ArrayList<SingleSignOnService>(nodes.size());
        for (Node node : nodes) {
            Element element = (Element)node;
            String location = element.getAttribute("Location");
            String binding = element.getAttribute("Binding");
            result.add(new SingleSignOnService(location, binding));
        }
        return result;
    }

    private List<SingleLogoutService> parseSloServices(Element idpSSODescriptor) {
        List<Node> nodes = IDPConfigParser.getChildren(idpSSODescriptor, "urn:oasis:names:tc:SAML:2.0:metadata", "SingleLogoutService");
        ArrayList<SingleLogoutService> result = new ArrayList<SingleLogoutService>();
        for (Node node : nodes) {
            Element element = (Element)node;
            String location = element.getAttribute("Location");
            String binding = element.getAttribute("Binding");
            result.add(new SingleLogoutService(location, binding));
        }
        return result;
    }

    private void checkIfExpired(Element entity) throws ParseException {
        String expDateValue = entity.getAttribute("validUntil");
        if (expDateValue.isEmpty()) {
            return;
        }
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Date currentDate = Calendar.getInstance(timeZone).getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(timeZone);
        Date expDate = sdf.parse(expDateValue);
        if (expDate.before(currentDate)) {
            return;
        }
        throw new RuntimeException("Expired IDP configuration.");
    }

    private static final class EnumImpl
    implements Enumeration<Node> {
        private final NodeList _nodes;
        private int _current = 0;

        EnumImpl(NodeList nodes) {
            Validate.notNull((Object)nodes, (String)"nodes");
            this._nodes = nodes;
        }

        @Override
        public boolean hasMoreElements() {
            return this._current < this._nodes.getLength();
        }

        @Override
        public Node nextElement() {
            return this._nodes.item(this._current++);
        }
    }
}

