/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class AsyncCollection<T>
implements Iterable<T> {
    private final Object _lock = new Object();
    private final List<Object> _availItems = new ArrayList<Object>();
    private volatile Object[] _iterItems = new Object[0];
    private volatile boolean _closed = false;

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object item) {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                throw new IllegalStateException("closed");
            }
            this._availItems.add(item);
            this._lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this._lock.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateIterItems(int fromIndex) {
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex");
        }
        Object object = this._lock;
        synchronized (object) {
            while (fromIndex >= this._iterItems.length) {
                if (fromIndex < this._availItems.size()) {
                    this._iterItems = this._availItems.toArray();
                    return true;
                }
                if (this._closed) {
                    return false;
                }
                try {
                    this._lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
    }

    private class IteratorImpl
    implements Iterator<T> {
        private int _index;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            if (this._index < AsyncCollection.this._iterItems.length) {
                return true;
            }
            return AsyncCollection.this.updateIterItems(this._index);
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return AsyncCollection.this._iterItems[this._index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

