/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

public class ClassLoaderUtils {
    private static final ThreadLocal<ClassLoader> PREV_LOADER = new ThreadLocal();

    public static void switchLoader(ClassLoader newLoader) {
        PREV_LOADER.set(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(newLoader);
    }

    public static void restoreLoader() {
        Thread.currentThread().setContextClassLoader(PREV_LOADER.get());
        PREV_LOADER.remove();
    }
}

