/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.dr.ui.tools.utilities.threadcontexthelpers.LogContextSetter;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.XmlExporter;
import com.vmware.vr.client.impex.tool.XmlImporter;
import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.InputWaiterRequester;
import com.vmware.vr.client.impex.tool.io.args.Arguments;
import com.vmware.vr.client.impex.tool.io.args.ArgumentsParser;
import com.vmware.vr.client.impex.tool.io.data.UserInputProperties;
import com.vmware.vr.client.impex.workflow.HmsTopologyCreator;
import com.vmware.vr.client.impex.workflow.TopologyCreator;
import com.vmware.vr.client.impex.workflow.UserInteractor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static IOHelper ioHelper;
    private static InputWaiterRequester waiter;

    public static void main(String[] args) throws IOException {
        InputWaiterRequester.ExitStatus exitStatus;
        Arguments arguments;
        Main.logVersionAndBuildNumber();
        ioHelper = UserInteractor.getIoHelper();
        ioHelper.writeln("Copyright (c) 2020-2024 Broadcom. All Rights Reserved.\nBroadcom Confidential. The term \"Broadcom\" refers to Broadcom Inc. and/or its subsidiaries.\n");
        try {
            arguments = ArgumentsParser.parse(args);
        }
        catch (Exception e) {
            LOGGER.error("ERROR_LOG_PREFIX_" + e.getMessage());
            System.exit(1);
            return;
        }
        String propertiesFilePath = arguments.getPropertiesFilePath();
        if (Objects.isNull(propertiesFilePath)) {
            ioHelper.writeln("Initiating CMD interaction.");
            if (arguments.isInteractive()) {
                UserInteractor.initFromStdIn();
            } else {
                UserInteractor.initFromStdInUsingCmdArgs(arguments);
            }
        } else {
            ioHelper.writeln("Initiating using properties file.");
            try {
                UserInteractor.initFromFile(propertiesFilePath);
            }
            catch (UserInputProperties.InvalidPropertyException | IOException e) {
                LOGGER.error("ERROR_LOG_PREFIX_" + e.getMessage());
                ioHelper.writeln("Unable to initiate using properties file: " + e.getMessage());
                System.exit(2);
                return;
            }
        }
        waiter = UserInteractor.getInputWaiter();
        Callable<Promise> impexTask = () -> TopologyCreator.create().onError(e -> Main.completeWithError(3, e.getMessage())).thenCompose(topology -> HmsTopologyCreator.getInstance().selectServerPair((TopologyImpl)topology).onError(e -> Main.completeWithError(4, e.getMessage())).thenCompose(pairSetup -> HmsTopologyCreator.createWrapper(topology, (PairSetup<HmsServer>)pairSetup)).onError(e -> Main.completeWithError(5, e.getMessage())).thenCompose(serversData -> {
            if (arguments.doImport()) {
                return Main.doImportHms((HmsServersDataWrapper)serversData, arguments.getPath(), arguments.isEnhancedReplication());
            }
            return Main.doExportHms((HmsServersDataWrapper)serversData, arguments.formatted(), arguments.getExportPath());
        })).onError(e -> Main.completeWithError(6, e.getMessage()));
        try {
            ThreadContext.setupContext(impexTask, (ContextApplier)LogContextSetter.createApplier((String)"operationID", (Object)"impex-fixed-op-id"));
        }
        catch (Exception e) {
            Main.completeWithError(10, "Unable to configure logging.");
        }
        try {
            exitStatus = waiter.waitForInput();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            exitStatus = new InputWaiterRequester.ExitStatus(7, "Unable to complete task.");
        }
        LOGGER.error("ERROR_LOG_PREFIX_" + exitStatus.getMessage());
        ioHelper.writeln(exitStatus.getMessage());
        System.exit(exitStatus.getCode());
    }

    private static void logVersionAndBuildNumber() throws IOException {
        Properties buildProperties = new Properties();
        try (InputStream in = Main.class.getResourceAsStream("/plugin-version.properties");){
            buildProperties.load(in);
        }
        LOGGER.info(String.format("Version %s. Build %s.", buildProperties.getProperty("version", "unknown"), buildProperties.getProperty("buildNumber", "unknown")));
    }

    private static Promise<Void> doExportHms(HmsServersDataWrapper hmsServersData, Boolean formatted, String path) {
        ioHelper.writeln("Starting export...");
        return new XmlExporter().exportConfigurables(hmsServersData, formatted, path).onSuccess(done -> waiter.complete(0, "Export ended.")).onSuccess(done -> LOGGER.info("Export VR configuration ended.")).onError(error -> {
            String errorMsg = error.getLocalizedMessage();
            Main.completeWithError(8, (String)(StringUtils.isEmpty(errorMsg) ? "Export ended with errors, check log for more information." : "Export ended with errors, check log for more information. Error: " + errorMsg));
        }).onError(error -> LOGGER.error("Export VR configuration ended.", (Throwable)error)).materialize().thenApply(result -> null);
    }

    private static Promise<Void> doImportHms(HmsServersDataWrapper hmsServersData, String path, boolean isEnhancedReplication) {
        return new XmlImporter().importHmsConfigurables(hmsServersData, Paths.get(path, new String[0]).toFile(), isEnhancedReplication).onSuccess(done -> waiter.complete(0, "Import ended.")).onSuccess(done -> LOGGER.info("Import VR configuration ended.")).onError(error -> {
            String errorMsg = error.getLocalizedMessage();
            Main.completeWithError(9, (String)(StringUtils.isEmpty(errorMsg) ? "Import ended with errors, check log for more information." : "Import ended with errors, check log for more information. Error: " + errorMsg));
        }).onError(error -> LOGGER.error("Import VR configuration ended.", (Throwable)error)).materialize().thenApply(result -> null);
    }

    private static void completeWithError(int exitCode, String errorMessage) {
        waiter.complete(exitCode, errorMessage);
    }
}

