/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vr.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.vr.client.impex.importers.replications.ReplicationGroupsImporter;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.ImpexImportHmsContext;
import com.vmware.vr.client.impex.utils.IContextUtil;
import com.vmware.vr.client.impex.utils.MappingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlImporterHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlImporterHelper.class);

    public static Promise<Profile[]> getProfiles(SpbmService spbmService, String guid) {
        return MappingUtil.getProfiles(spbmService).onSuccess(unused -> LOGGER.debug("Getting profiles for server with guid '{}'.", (Object)guid)).onError(error -> LOGGER.warn("Error while getting profiles for server with guid '{}'.", (Object)guid, error));
    }

    public static Promise<Void> importReplications(InventoryExtractor.InventoryLookup inventory, Profile[] localProfiles, Profile[] remoteProfiles) {
        LOGGER.debug("Starting import of replications.");
        Promise<Void> localImport = XmlImporterHelper.importReplications(true, inventory, remoteProfiles);
        boolean isROBO = ((HmsService)IContextUtil.getHmsServer(true).service()).equals((Object)IContextUtil.getHmsServer(false).service());
        if (isROBO) {
            LOGGER.info("Starting import of replications in ROBO mode.");
            return localImport;
        }
        Promise<Void> remoteImport = XmlImporterHelper.importReplications(false, inventory, localProfiles);
        return localImport.thenCombine(remoteImport, (localUnused, remoteUnused) -> null);
    }

    private static Promise<Void> importReplications(boolean local, InventoryExtractor.InventoryLookup inventory, Profile[] remoteProfiles) {
        HmsServersDataWrapper serversData = ImpexImportHmsContext.get().getServersDataWrapper();
        String guid = local ? ((HmsServer)serversData.getLocalPair().server()).guid() : ((HmsServer)serversData.getRemotePair().server()).guid();
        return new ReplicationGroupsImporter(local, inventory, remoteProfiles).create().onSuccess(done -> LOGGER.debug("Importing Replication Group for server with guid '{}' is complete.", (Object)guid)).onError(error -> LOGGER.warn("Error while importing Replication Group for server with guid '{}'.", (Object)guid, error)).materialize().thenApply(unused -> null);
    }
}

