/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.InputWaiterRequester;
import com.vmware.vr.client.impex.tool.io.args.Arguments;
import com.vmware.vr.client.impex.tool.io.data.Credentials;
import com.vmware.vr.client.impex.tool.io.data.Lspp;
import com.vmware.vr.client.impex.tool.io.request.FinalRequest;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class CmdInputWR
extends InputWaiterRequester {
    private final Arguments _args;
    private final AtomicBoolean _localCredentialsRequested = new AtomicBoolean(false);
    private final AtomicBoolean _remoteCredentialsRequested = new AtomicBoolean(false);

    public CmdInputWR(IOHelper ioHelper, Arguments arguments) {
        super(ioHelper);
        this._args = arguments;
    }

    @Override
    public Promise<Lspp> promptForLspp() {
        return Promises.resolve((Object)this._args.getLspp());
    }

    @Override
    public Promise<Boolean> promptForThumbprint(String host, String thumbprint) {
        return Promises.resolve((Object)true);
    }

    @Override
    public Promise<Credentials> promptForLocalCredentials(String host) {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local credentials have already been requested."));
        }
        return Promises.resolve((Object)((Object)this._args.getLocalCredentials()));
    }

    @Override
    public Promise<String> promptForLocalHmsServer(Map<String, String> guidToName) {
        return Promises.resolve((Object)this.getHmsServerGuid(guidToName, this._args.getLocalHmsName()));
    }

    @Override
    public Promise<Boolean> promptForUsingLocalServiceAccount(String host) {
        return Promises.resolve((Object)this._args.isLocalUseServiceAccount());
    }

    @Override
    public Promise<String> promptForLocalSAPath() {
        return Promises.resolve((Object)this._args.getLocalSAPath());
    }

    @Override
    public Promise<String> promptForRemoteHmsServer(Map<String, String> guidToName) {
        return Promises.resolve((Object)this.getHmsServerGuid(guidToName, this._args.getRemoteHmsName()));
    }

    @Override
    public Promise<Credentials> promptForRemoteCredentials(String serverName) {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote credentials have already been requested."));
        }
        return Promises.resolve((Object)((Object)this._args.getRemoteCredentials()));
    }

    @Override
    public Promise<Boolean> promptForUsingRemoteServiceAccount(String host) {
        return Promises.resolve((Object)this._args.isRemoteUseServiceAccount());
    }

    @Override
    public Promise<String> promptForRemoteSAPath(String host) {
        return Promises.resolve((Object)this._args.getRemoteSAPath());
    }

    @Override
    public void complete(int exitCode, String completionMessage) {
        this._requests.add(new FinalRequest(exitCode, completionMessage));
    }

    protected String getHmsServerGuid(Map<String, String> guidToName, String hmsNameToFind) {
        return guidToName.entrySet().stream().filter(entry -> hmsNameToFind.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalArgumentException("No VR server named '" + hmsNameToFind + "' is found."));
    }
}

