/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.InputWaiterRequester;
import com.vmware.vr.client.impex.tool.io.data.Credentials;
import com.vmware.vr.client.impex.tool.io.data.Lspp;
import com.vmware.vr.client.impex.tool.io.data.UserInputProperties;
import com.vmware.vr.client.impex.tool.io.request.FinalRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileInputWR
extends InputWaiterRequester {
    private final UserInputProperties _properties;
    private final AtomicBoolean _localCredentialsRequested = new AtomicBoolean(false);
    private final AtomicBoolean _remoteCredentialsRequested = new AtomicBoolean(false);
    private final Set<String> _requestedAms = Collections.synchronizedSet(new HashSet());

    public FileInputWR(IOHelper ioHelper, UserInputProperties properties) {
        super(ioHelper);
        this._properties = properties;
    }

    @Override
    public Promise<Lspp> promptForLspp() {
        return Promises.resolve((Object)this._properties.getLspp());
    }

    @Override
    public Promise<Boolean> promptForThumbprint(String host, String thumbprint) {
        return Promises.resolve((Object)true);
    }

    @Override
    public Promise<Credentials> promptForLocalCredentials(String host) {
        if (this._localCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Local credentials have already been requested."));
        }
        return this.validateCredentials(this._properties.getLocalCredentials(), host);
    }

    @Override
    public Promise<String> promptForLocalHmsServer(Map<String, String> guidToName) {
        return this.promptForServer(guidToName, this._properties.getLocalHmsName());
    }

    @Override
    public Promise<Boolean> promptForUsingLocalServiceAccount(String host) {
        return Promises.resolve((Object)this._properties.isLocalUseServiceAccount());
    }

    @Override
    public Promise<String> promptForLocalSAPath() {
        return Promises.resolve((Object)this._properties.getLocalSAPath());
    }

    @Override
    public Promise<String> promptForRemoteHmsServer(Map<String, String> guidToName) {
        return this.promptForServer(guidToName, this._properties.getRemoteHmsName());
    }

    private Promise<String> promptForServer(Map<String, String> guidToName, String serverName) {
        String guid = guidToName.entrySet().stream().filter(entry -> serverName.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null);
        if (Objects.isNull(guid)) {
            return Promises.reject((Exception)new IllegalArgumentException("No server named '" + serverName + "' is found."));
        }
        return Promises.resolve((Object)guid);
    }

    @Override
    public Promise<Credentials> promptForRemoteCredentials(String serverName) {
        if (this._remoteCredentialsRequested.getAndSet(true)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("Remote credentials have already been requested."));
        }
        return this.validateCredentials(this._properties.getRemoteCredentials(), serverName);
    }

    @Override
    public Promise<Boolean> promptForUsingRemoteServiceAccount(String host) {
        return Promises.resolve((Object)this._properties.isRemoteUseServiceAccount());
    }

    @Override
    public Promise<String> promptForRemoteSAPath(String host) {
        return Promises.resolve((Object)this._properties.getRemoteSAPath());
    }

    @Override
    public void complete(int exitCode, String completionMessage) {
        this._requests.add(new FinalRequest(exitCode, completionMessage));
    }

    private Promise<Credentials> validateCredentials(Credentials credentials, String target) {
        if (Objects.isNull((Object)credentials)) {
            return Promises.reject((Exception)new InputWaiterRequester.RejectedException("No credentials provided for: " + target));
        }
        return Promises.resolve((Object)((Object)credentials));
    }
}

