/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io.args;

import com.vmware.vr.client.impex.tool.io.IOHelper;
import com.vmware.vr.client.impex.tool.io.args.Arguments;
import com.vmware.vr.client.impex.tool.io.data.Credentials;
import com.vmware.vr.client.impex.tool.io.data.Lspp;
import com.vmware.vr.client.impex.workflow.UserInteractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;

public class ArgumentsParser {
    private static final String CMD_PARAM_VR_LOCAL_SERVER_NAME = "localVrName";
    private static final String CMD_PARAM_VR_REMOTE_SERVER_NAME = "remoteVrName";
    private static final String CMD_PARAM_CONN_LSPP = "lspp";
    private static final String CMD_PARAM_CONN_PORT = "port";
    private static final String CMD_PARAM_AUTH_L_USE_SA = "localAuthUseSA";
    private static final String CMD_PARAM_AUTH_L_SA_PATH = "localAuthSAPath";
    private static final String CMD_PARAM_AUTH_L_CREDS_USERNAME = "localAuthCredsUsername";
    private static final String CMD_PARAM_AUTH_L_CREDS_PASS = "localAuthCredsPass";
    private static final String CMD_PARAM_AUTH_R_USE_SA = "remoteAuthUseSA";
    private static final String CMD_PARAM_AUTH_R_SA_PATH = "remoteAuthSAPath";
    private static final String CMD_PARAM_AUTH_R_CREDS_USERNAME = "remoteAuthCredsUsername";
    private static final String CMD_PARAM_AUTH_R_CREDS_PASS = "remoteAuthCredsPass";
    private static final String CMD_PARAM_EXPORT_FORMAT = "format";
    private static final String CMD_PARAM_EXPORT_PATH = "exportPath";
    private static final String CMD_PARAM_CONF_EXPORT_CMD = "export";
    private static final String CMD_PARAM_CONF_EXPORT_INTERACTIVE = "exportInteractive";
    private static final String CMD_PARAM_CONF_EXPORT_PROPERTIES = "exportProperties";
    private static final String CMD_PARAM_IMPORT_PATH = "path";
    private static final String CMD_PARAM_IMPORT_ENHANCED_REPLICATION = "enhancedReplication";
    private static final String CMD_PARAM_CONF_IMPORT_INTERACTIVE = "importInteractive";
    private static final String CMD_PARAM_CONF_IMPORT_PROPERTIES = "importProperties";

    public static Arguments parse(String[] args) {
        OptionParser parser = ArgumentsParser.createParser();
        try {
            OptionSet options = parser.parse(args);
            ArgumentsParser.checkConfigArgs(options);
            ArgumentsParser.checkExportArgs(options);
            ArgumentsParser.checkImportArgs(options);
            ArgumentsParser.checkHmsConnectionArgs(options);
            ArgumentsParser.checkLocalAuthArgs(options);
            ArgumentsParser.checkRemoteAuthArgs(options);
            return ArgumentsParser.getArguments(options);
        }
        catch (RuntimeException e) {
            IOHelper ioHelper = UserInteractor.getIoHelper();
            ioHelper.writeln(e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null) {
                ioHelper.writeln(cause.getMessage());
            }
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                parser.printHelpOn((OutputStream)os);
                ioHelper.writeln(os.toString(StandardCharsets.UTF_8.toString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Invalid arguments.");
        }
    }

    private static Arguments getArguments(OptionSet options) {
        boolean isImport;
        Lspp lspp = null;
        boolean lUseSA = options.has(CMD_PARAM_AUTH_L_USE_SA);
        Credentials lCreds = null;
        String lSAPath = null;
        boolean rUseSA = options.has(CMD_PARAM_AUTH_R_USE_SA);
        Credentials rCreds = null;
        String rSAPath = null;
        String localHmsName = null;
        String remoteHmsName = null;
        if (options.has(CMD_PARAM_CONF_EXPORT_CMD)) {
            lspp = new Lspp((String)options.valueOf(CMD_PARAM_CONN_LSPP), (Integer)options.valueOf(CMD_PARAM_CONN_PORT));
            if (options.has(CMD_PARAM_VR_LOCAL_SERVER_NAME)) {
                localHmsName = (String)options.valueOf(CMD_PARAM_VR_LOCAL_SERVER_NAME);
            }
            if (options.has(CMD_PARAM_VR_REMOTE_SERVER_NAME)) {
                remoteHmsName = (String)options.valueOf(CMD_PARAM_VR_REMOTE_SERVER_NAME);
            }
            if (lUseSA) {
                lSAPath = (String)options.valueOf(CMD_PARAM_AUTH_L_SA_PATH);
            } else {
                lCreds = new Credentials((String)options.valueOf(CMD_PARAM_AUTH_L_CREDS_USERNAME), (String)options.valueOf(CMD_PARAM_AUTH_L_CREDS_PASS));
            }
            if (rUseSA) {
                rSAPath = (String)options.valueOf(CMD_PARAM_AUTH_R_SA_PATH);
            } else {
                rCreds = new Credentials((String)options.valueOf(CMD_PARAM_AUTH_R_CREDS_USERNAME), (String)options.valueOf(CMD_PARAM_AUTH_R_CREDS_PASS));
            }
        }
        String properties = (String)((isImport = ArgumentsParser.isImport(options)) ? options.valueOf(CMD_PARAM_CONF_IMPORT_PROPERTIES) : options.valueOf(CMD_PARAM_CONF_EXPORT_PROPERTIES));
        return new Arguments(isImport, ArgumentsParser.isInteractive(options), properties, options.has(CMD_PARAM_EXPORT_FORMAT), (String)options.valueOf(CMD_PARAM_EXPORT_PATH), (String)options.valueOf(CMD_PARAM_IMPORT_PATH), lspp, localHmsName, remoteHmsName, lUseSA, lSAPath, lCreds, rUseSA, rSAPath, rCreds, options.has(CMD_PARAM_IMPORT_ENHANCED_REPLICATION));
    }

    private static OptionParser createParser() {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new NonAlphabeticalHelpFormatter());
        ArgumentsParser.addConfigArgs(parser);
        ArgumentsParser.addConnectionArgs(parser);
        ArgumentsParser.addLocalAuthArgs(parser);
        ArgumentsParser.addRemoteAuthArgs(parser);
        ArgumentsParser.addImportArgs(parser);
        ArgumentsParser.addExportArgs(parser);
        return parser;
    }

    private static void addConfigArgs(OptionParser parser) {
        OptionSpecBuilder exportCmd = parser.accepts(CMD_PARAM_CONF_EXPORT_CMD, "Use to start an export passing the needed information on the command line.");
        OptionSpecBuilder exportProperties = parser.accepts(CMD_PARAM_CONF_EXPORT_PROPERTIES, "Use to start an export using properties file to pass the needed information.");
        OptionSpecBuilder exportInteractive = parser.accepts(CMD_PARAM_CONF_EXPORT_INTERACTIVE, "Use to start an export interactively, being prompted for needed information.");
        OptionSpecBuilder importProperties = parser.accepts(CMD_PARAM_CONF_IMPORT_PROPERTIES, "Use to start an import using properties file to pass the needed information.");
        OptionSpecBuilder importInteractive = parser.accepts(CMD_PARAM_CONF_IMPORT_INTERACTIVE, "Use to start an import interactively, being prompted for needed information.");
        exportProperties.withRequiredArg().ofType(String.class);
        importProperties.withRequiredArg().ofType(String.class);
        exportCmd.requiredUnless(CMD_PARAM_CONF_EXPORT_PROPERTIES, new String[]{CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        exportProperties.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        exportInteractive.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_PROPERTIES, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        importProperties.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_INTERACTIVE});
        importInteractive.requiredUnless(CMD_PARAM_CONF_EXPORT_CMD, new String[]{CMD_PARAM_CONF_EXPORT_PROPERTIES, CMD_PARAM_CONF_EXPORT_INTERACTIVE, CMD_PARAM_CONF_IMPORT_PROPERTIES});
    }

    private static void checkConfigArgs(OptionSet optionSet) {
        boolean hasExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean hasExportProperties = optionSet.has(CMD_PARAM_CONF_EXPORT_PROPERTIES);
        boolean hasExportInteractive = optionSet.has(CMD_PARAM_CONF_EXPORT_INTERACTIVE);
        boolean hasImportProperties = optionSet.has(CMD_PARAM_CONF_IMPORT_PROPERTIES);
        boolean hasImportInteractive = optionSet.has(CMD_PARAM_CONF_IMPORT_INTERACTIVE);
        int sum = hasExportCmd ? 1 : 0;
        sum += hasExportProperties ? 1 : 0;
        sum += hasExportInteractive ? 1 : 0;
        sum += hasImportProperties ? 1 : 0;
        if ((sum += hasImportInteractive ? 1 : 0) != 1) {
            throw new RuntimeException("Options 'export', 'exportProperties', 'exportInteractive', 'importProperties' and 'importInteractive' cannot be used together.");
        }
    }

    private static void addExportArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_EXPORT_FORMAT, "[export] Use to make the exported XML file formatted and human-readable. *This will significantly increase the file size!");
        parser.accepts(CMD_PARAM_EXPORT_PATH, "[export] Pass a directory in which the exported file to be created.").withRequiredArg().ofType(String.class);
    }

    private static void checkExportArgs(OptionSet optionSet) {
        if (ArgumentsParser.isImport(optionSet) && (optionSet.has(CMD_PARAM_EXPORT_FORMAT) || optionSet.has(CMD_PARAM_EXPORT_PATH))) {
            throw new RuntimeException("Options 'format' and 'exportPath' are relevant when doing an export only.");
        }
    }

    private static void addImportArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_IMPORT_PATH, "[import] Path of the file to load - the previously exported file.").requiredIf(CMD_PARAM_CONF_IMPORT_INTERACTIVE, new String[]{CMD_PARAM_CONF_IMPORT_PROPERTIES}).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_IMPORT_ENHANCED_REPLICATION, "[import] Import replications with enhanced mode.");
    }

    private static void checkImportArgs(OptionSet optionSet) {
        if ((optionSet.has(CMD_PARAM_IMPORT_PATH) || optionSet.has(CMD_PARAM_IMPORT_ENHANCED_REPLICATION)) && !ArgumentsParser.isImport(optionSet)) {
            throw new RuntimeException("Options 'path' and 'enhancedReplication' are relevant when doing an import only.");
        }
    }

    private static void addConnectionArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_CONN_LSPP, "The Platform Services Controller address. Can be an IP address or FQDN.").requiredIf(CMD_PARAM_CONF_EXPORT_CMD, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_CONN_PORT, "The port number for the Lookup Service. The default value is 443.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)443, (Object[])new Integer[0]).withValuesConvertedBy((ValueConverter)new RangeValueConverter());
        parser.accepts(CMD_PARAM_VR_LOCAL_SERVER_NAME, "The name of the local vSphere Replication Server.").withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_VR_REMOTE_SERVER_NAME, "The name of the remote vSphere Replication Server.").withRequiredArg().ofType(String.class);
    }

    private static void checkHmsConnectionArgs(OptionSet optionSet) {
        boolean isExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean isImportProperties = optionSet.has(CMD_PARAM_CONF_IMPORT_PROPERTIES);
        boolean isImportInteractive = optionSet.has(CMD_PARAM_CONF_IMPORT_INTERACTIVE);
        boolean hasLocalHms = optionSet.has(CMD_PARAM_VR_LOCAL_SERVER_NAME);
        boolean hasRemoteHms = optionSet.has(CMD_PARAM_VR_REMOTE_SERVER_NAME);
        if (!(isImportProperties || isImportInteractive || !isExportCmd || hasLocalHms && hasRemoteHms)) {
            throw new RuntimeException("Options 'localVrName' and 'remoteVrName' are required when NOT using 'importProperties' or 'importInteractive' or USING 'export' .");
        }
    }

    private static void addLocalAuthArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_AUTH_L_USE_SA, "Use to specify whether to use a Service Account file to log in on the local site.");
        parser.accepts(CMD_PARAM_AUTH_L_CREDS_USERNAME, "[User name and password local authentication] Required when not using SA. The user name for the local vCenter Server.").withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_L_CREDS_PASS, "[User name and password remote authentication] The password for the vCenter Server.").requiredIf(CMD_PARAM_AUTH_L_CREDS_USERNAME, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_L_SA_PATH, "[Service account local authentication] Path to the Service Account file.").requiredIf(CMD_PARAM_AUTH_L_USE_SA, new String[0]).withRequiredArg().ofType(String.class);
    }

    private static void checkLocalAuthArgs(OptionSet optionSet) {
        boolean isExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean useSA = optionSet.has(CMD_PARAM_AUTH_L_USE_SA);
        boolean credsUsername = optionSet.has(CMD_PARAM_AUTH_L_CREDS_USERNAME);
        boolean credsPass = optionSet.has(CMD_PARAM_AUTH_L_CREDS_PASS);
        boolean saPath = optionSet.has(CMD_PARAM_AUTH_L_SA_PATH);
        if (isExportCmd && !(useSA ^ credsUsername)) {
            throw new RuntimeException("Only one of options 'localAuthUseSA' and 'localAuthCredsUsername' are needed when using 'export'");
        }
        if (!isExportCmd && (useSA || credsUsername || credsPass)) {
            throw new RuntimeException("Options 'localAuthUseSA', 'localAuthCredsUsername', 'localAuthCredsPass' are relevant when using 'export' only.");
        }
        if (useSA && (credsUsername || credsPass)) {
            throw new RuntimeException("Options 'localAuthCredsUsername' and 'localAuthCredsPass' cannot be used along with'localAuthUseSA'.");
        }
        if (!useSA && saPath) {
            throw new RuntimeException("Option 'localAuthSAPath' can only be used along with'localAuthUseSA'.");
        }
    }

    private static void addRemoteAuthArgs(OptionParser parser) {
        parser.accepts(CMD_PARAM_AUTH_R_USE_SA, "Use to specify whether to use a Service Account file to log in on the remote site.");
        parser.accepts(CMD_PARAM_AUTH_R_CREDS_USERNAME, "[User name and password remote authentication] Required when not using SA. The user name for the remote vCenter Server.").withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_R_CREDS_PASS, "[User name and password remote authentication] The password for the vCenter Server.").requiredIf(CMD_PARAM_AUTH_R_CREDS_USERNAME, new String[0]).withRequiredArg().ofType(String.class);
        parser.accepts(CMD_PARAM_AUTH_R_SA_PATH, "[Service account remote authentication] Path to the Service Account file.").requiredIf(CMD_PARAM_AUTH_R_USE_SA, new String[0]).withRequiredArg().ofType(String.class);
    }

    private static void checkRemoteAuthArgs(OptionSet optionSet) {
        boolean isExportCmd = optionSet.has(CMD_PARAM_CONF_EXPORT_CMD);
        boolean useSA = optionSet.has(CMD_PARAM_AUTH_R_USE_SA);
        boolean saPath = optionSet.has(CMD_PARAM_AUTH_R_SA_PATH);
        boolean credsUsername = optionSet.has(CMD_PARAM_AUTH_R_CREDS_USERNAME);
        boolean credsPass = optionSet.has(CMD_PARAM_AUTH_R_CREDS_PASS);
        if (isExportCmd && !(useSA ^ credsUsername)) {
            throw new RuntimeException("Only one of options 'remoteAuthUseSA' and 'remoteAuthCredsUsername' are needed when using 'export'");
        }
        if (!isExportCmd && (useSA || credsUsername || credsPass)) {
            throw new RuntimeException("Options 'remoteAuthUseSA', 'remoteAuthCredsUsername', 'remoteAuthCredsPass' are relevant when using 'export' only.");
        }
        if (useSA && (credsUsername || credsPass)) {
            throw new RuntimeException("Options 'remoteAuthCredsUsername' and 'remoteAuthCredsPass' cannot be used along with'remoteAuthUseSA");
        }
        if (!useSA && saPath) {
            throw new RuntimeException("Option 'remoteAuthSAPath' can only be used along with'remoteAuthUseSA'.");
        }
    }

    private static boolean isImport(OptionSet optionSet) {
        return optionSet.has(CMD_PARAM_CONF_IMPORT_PROPERTIES) || optionSet.has(CMD_PARAM_CONF_IMPORT_INTERACTIVE);
    }

    private static boolean isInteractive(OptionSet optionSet) {
        return optionSet.has(CMD_PARAM_CONF_EXPORT_INTERACTIVE) || optionSet.has(CMD_PARAM_CONF_IMPORT_INTERACTIVE);
    }

    private static final class NonAlphabeticalHelpFormatter
    extends BuiltinHelpFormatter {
        private static final int DESIRED_OVERALL_WIDTH = 180;
        private static final int DESIRED_COLUMN_SEPARATOR_WIDTH = 2;

        NonAlphabeticalHelpFormatter() {
            super(180, 2);
        }

        public String format(Map<String, ? extends OptionDescriptor> options) {
            this.addRows(options.values());
            return this.formattedHelpOutput();
        }
    }

    private static final class RangeValueConverter
    implements ValueConverter<Integer> {
        private RangeValueConverter() {
        }

        public Integer convert(String value) {
            int intVal;
            try {
                intVal = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ValueConversionException("An integer value is required.", e.getCause());
            }
            if (intVal < 0) {
                throw new ValueConversionException("A non-negative integer value is required.");
            }
            return intVal;
        }

        public Class<Integer> valueType() {
            return Integer.class;
        }

        public String valuePattern() {
            return "[1, 2147483647]";
        }
    }
}

