/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io.data;

import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.vim.vmomi.core.util.StringUtil;
import com.vmware.vr.client.impex.tool.io.data.Credentials;
import com.vmware.vr.client.impex.tool.io.data.Lspp;
import java.util.Objects;
import java.util.Properties;

public class UserInputProperties {
    private static final String ADDRESS = "lookup.service.address";
    private static final String PORT = "port";
    private static final String PROPERTY_LOCAL_VR_NAME = "local.vr.name";
    private static final String PROPERTY_REMOTE_VR_NAME = "remote.vr.name";
    private static final String LOCAL_AUTH_USE_SA = "local.auth.use.service.account";
    private static final String LOCAL_AUTH_SA_PATH = "local.auth.sa.path";
    private static final String LOCAL_AUTH_USERNAME = "local.auth.credentials.vc.username";
    private static final String LOCAL_AUTH_PASSWORD = "local.auth.credentials.vc.password";
    private static final String REMOTE_AUTH_USE_SA = "remote.auth.use.service.account";
    private static final String REMOTE_AUTH_SA_PATH = "remote.auth.sa.path";
    private static final String REMOTE_AUTH_USERNAME = "remote.auth.credentials.vc.username";
    private static final String REMOTE_AUTH_PASSWORD = "remote.auth.credentials.vc.password";
    private final Lspp _lspp;
    private final String _localHmsName;
    private final String _remoteHmsName;
    private final boolean _localUseServiceAccount;
    private final String _localSAPath;
    private final Credentials _localCredentials;
    private final boolean _remoteUseServiceAccount;
    private final String _remoteSAPath;
    private final Credentials _remoteCredentials;

    public UserInputProperties(Properties properties) throws InvalidPropertyException {
        String host = properties.getProperty(ADDRESS);
        String port = properties.getProperty(PORT);
        if (Objects.isNull(port)) {
            port = String.valueOf(443);
        }
        if (!org.apache.commons.lang.StringUtils.isNumeric(port)) {
            throw new NonNumericPropertyException(PORT);
        }
        this._lspp = new Lspp(host, Integer.valueOf(port));
        String localHmsName = properties.getProperty(PROPERTY_LOCAL_VR_NAME);
        String remoteHmsName = properties.getProperty(PROPERTY_REMOTE_VR_NAME);
        this._localHmsName = localHmsName;
        UserInputProperties.validateNotEmpty(host, ADDRESS);
        UserInputProperties.validateNotEmpty(remoteHmsName, PROPERTY_REMOTE_VR_NAME);
        UserInputProperties.validateNotEmpty(localHmsName, PROPERTY_LOCAL_VR_NAME);
        this._remoteHmsName = remoteHmsName;
        String localUseSA = properties.getProperty(LOCAL_AUTH_USE_SA);
        this._localUseServiceAccount = Boolean.parseBoolean(localUseSA);
        if (this._localUseServiceAccount) {
            this._localSAPath = properties.getProperty(LOCAL_AUTH_SA_PATH);
            this._localCredentials = null;
        } else {
            String localVcUsername = properties.getProperty(LOCAL_AUTH_USERNAME);
            UserInputProperties.validateNotEmpty(localVcUsername, LOCAL_AUTH_USERNAME);
            String localVcPassword = properties.getProperty(LOCAL_AUTH_PASSWORD);
            UserInputProperties.validateNotNull(localVcPassword, LOCAL_AUTH_PASSWORD);
            this._localCredentials = new Credentials(localVcUsername, localVcPassword);
            this._localSAPath = null;
        }
        String remoteUseServiceAccount = properties.getProperty(REMOTE_AUTH_USE_SA);
        this._remoteUseServiceAccount = Boolean.parseBoolean(remoteUseServiceAccount);
        if (this._remoteUseServiceAccount) {
            this._remoteSAPath = properties.getProperty(REMOTE_AUTH_SA_PATH);
            this._remoteCredentials = null;
        } else {
            String remoteVcUsername = properties.getProperty(REMOTE_AUTH_USERNAME);
            String remoteVcPassword = properties.getProperty(REMOTE_AUTH_PASSWORD);
            if (Objects.nonNull(remoteVcUsername)) {
                UserInputProperties.validateNotNull(remoteVcPassword, REMOTE_AUTH_PASSWORD);
            }
            this._remoteCredentials = Objects.isNull(remoteVcUsername) ? new Credentials("", "") : new Credentials(remoteVcUsername, remoteVcPassword);
            this._remoteSAPath = null;
        }
    }

    public Lspp getLspp() {
        return this._lspp;
    }

    public Credentials getLocalCredentials() {
        return this._localCredentials;
    }

    public String getLocalHmsName() {
        return this._localHmsName;
    }

    public String getRemoteHmsName() {
        return this._remoteHmsName;
    }

    public Credentials getRemoteCredentials() {
        return this._remoteCredentials;
    }

    public boolean isLocalUseServiceAccount() {
        return this._localUseServiceAccount;
    }

    public String getLocalSAPath() {
        return this._localSAPath;
    }

    public boolean isRemoteUseServiceAccount() {
        return this._remoteUseServiceAccount;
    }

    public String getRemoteSAPath() {
        return this._remoteSAPath;
    }

    private static void validateNotNull(String property, String key) {
        if (property == null) {
            throw new PropertyNotProvidedException(key);
        }
    }

    private static void validateNotEmpty(String property, String key) {
        UserInputProperties.validateNotNull(property, key);
        if (property.length() == 0) {
            throw new PropertyNotProvidedException(key);
        }
    }

    public String toString() {
        return "UserInputProperties {" + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_lspp = ", (Object)this._lspp)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_localVrName = ", (Object)(this._localHmsName == null ? "NULL" : this._localHmsName))), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_remoteVrName = ", (Object)(this._remoteHmsName == null ? "NULL" : this._remoteHmsName))), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_localUseServiceAccount = ", (Object)this._localUseServiceAccount)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_localSAPath = ", (Object)this._localSAPath)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_localCredentials = ", (Object)((Object)this._localCredentials))), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_remoteUseServiceAccount = ", (Object)this._remoteUseServiceAccount)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_remoteSAPath = ", (Object)this._remoteSAPath)), (boolean)false) + "," + StringUtil.indent((String)("\n" + StringUtils.toStringMemberObject((String)"_remoteCredentials = ", (Object)((Object)this._remoteCredentials))), (boolean)false) + "\n}";
    }

    private static final class NonNumericPropertyException
    extends InvalidPropertyException {
        private static final String MESSAGE = "Property '%s' is not a number.";

        NonNumericPropertyException(String key) {
            super(String.format(MESSAGE, key));
        }
    }

    private static final class PropertyNotProvidedException
    extends InvalidPropertyException {
        private static final String MESSAGE = "Property '%s' is required.";

        PropertyNotProvidedException(String key) {
            super(String.format(MESSAGE, key));
        }
    }

    public static class InvalidPropertyException
    extends RuntimeException {
        public InvalidPropertyException(String message) {
            super(message);
        }
    }
}

