/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.tasks.TaskUtil;
import com.vmware.srm.client.infrastructure.utils.DatastorePathUtil;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.client.vmomi.vc.VcService;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vr.client.impex.tool.ImpexExportHmsContext;
import com.vmware.vr.client.impex.tool.ImpexImportHmsContext;
import com.vmware.vr.client.impex.utils.HmsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStoreUtil.class);
    public static final String DATASTORE_VSAN_TYPE = "VSAN";
    public static final String DATASTORE_VVOL_TYPE = "VVOL";
    public static final String DATASTORE_VMFS_TYPE = "VMFS";
    public static final String DATASTORE_NFS_TYPE = "NFS";
    public static final String DATASTORE_NFS41_TYPE = "NFS41";

    public static Promise<String> getFolderFriendlyNameByPath(VcServer vcServer, String datastoreId, String path, String datastoreType, boolean isImport) {
        if (!DATASTORE_VSAN_TYPE.equals(datastoreType) && !DATASTORE_VVOL_TYPE.equals(datastoreType)) {
            return Promises.resolve((Object)path);
        }
        VcService vcService = (VcService)vcServer.service();
        Datastore ds = (Datastore)vcService.createStub(new ManagedObjectReference(HmsUtil.getVmodlTypeName(Datastore.class), datastoreId, vcServer.guid()));
        Promise<Datastore.Info> dsInfoPromise = DataStoreUtil.getDatastoreInfoWithCache(vcServer.guid(), ds, isImport);
        Promise vcVersionPromise = vcService.getContent().thenApply(content -> content.getAbout().getVersion());
        return dsInfoPromise.thenCombineCompose(vcVersionPromise, (dsInfo, vcVersion) -> DataStoreUtil.getObjectFriendlyNameInNewVsanAndVvol(vcService, ds, dsInfo, path));
    }

    public static Promise<DatastoreBrowser.FileInfo> searchDatastore(VcService vcService, String path, String pattern, ManagedObjectReference dataStore) {
        Promise dsBrowserPromise = PCUtil.retrieveProperty((ServersView)ImpexExportHmsContext.getServersDataWrapper().getView(), (ManagedObjectReference)dataStore, (String)"browser");
        return dsBrowserPromise.thenCompose(dsBrowserRef -> {
            DatastoreBrowser dsBrowser = (DatastoreBrowser)vcService.createStub(dsBrowserRef);
            FuturePromise fp = new FuturePromise();
            ArrayList<DatastoreBrowser.Query> queries = new ArrayList<DatastoreBrowser.Query>();
            queries.add((DatastoreBrowser.Query)new DatastoreBrowser.FolderQuery());
            queries.add(new DatastoreBrowser.Query());
            dsBrowser.search(path, DataStoreUtil.createSearchSpec(queries, pattern), (Future)fp);
            return fp.thenCompose(taskRef -> TaskUtil.waitForTaskToFinish((Service)vcService, (ManagedObjectReference)taskRef));
        }).thenApply(DataStoreUtil::adaptResult).thenApply(list -> list.stream().findFirst().orElse(null));
    }

    private static List<DatastoreBrowser.FileInfo> adaptResult(Object taskResult) {
        DatastoreBrowser.SearchResults[] typedResults = taskResult instanceof DatastoreBrowser.SearchResults[] ? (DatastoreBrowser.SearchResults[])taskResult : (taskResult instanceof DatastoreBrowser.SearchResults ? new DatastoreBrowser.SearchResults[]{(DatastoreBrowser.SearchResults)taskResult} : new DatastoreBrowser.SearchResults[]{});
        DatastorePathUtil.unescapeDatastoreNameInSearchResults((DatastoreBrowser.SearchResults[])typedResults);
        List<DatastoreBrowser.SearchResults> searchResults = Arrays.asList(typedResults);
        List<DatastoreBrowser.FileInfo> datastoresFileNodes = searchResults.stream().filter(result -> result.file != null).flatMap(result -> Arrays.stream(result.getFile())).collect(Collectors.toList());
        return datastoresFileNodes;
    }

    private static DatastoreBrowser.SearchSpec createSearchSpec(List<DatastoreBrowser.Query> queries, String pattern) {
        DatastoreBrowser.SearchSpec spec = new DatastoreBrowser.SearchSpec();
        spec.query = queries.toArray(new DatastoreBrowser.Query[queries.size()]);
        spec.searchCaseInsensitive = true;
        spec.sortFoldersFirst = true;
        spec.details = new DatastoreBrowser.FileInfo.Details();
        spec.details.fileOwner = true;
        spec.details.fileSize = true;
        spec.details.fileType = true;
        spec.details.modification = true;
        spec.matchPattern = pattern != null ? new String[]{pattern} : new String[0];
        return spec;
    }

    public static Promise<Datastore.Info> getDatastoreInfoWithCache(String vcGuid, Datastore ds, boolean isImport) {
        Datastore.Info dsInfo;
        if (ds._getRef() == null || ds._getRef().getValue() == null || ds._getRef().getValue().isEmpty()) {
            throw new RuntimeException("Cannot get datastore info from cache, datastore Id is null.");
        }
        String dsIdWithVcId = String.format("%s-%s", vcGuid, ds._getRef().getValue());
        Datastore.Info info2 = dsInfo = isImport ? ImpexImportHmsContext.get().getDatastoreInfoBy(dsIdWithVcId) : ImpexExportHmsContext.get().getDatastoreInfoBy(dsIdWithVcId);
        if (dsInfo == null) {
            return DataStoreUtil.getDatastoreInfo(ds).thenApply(info -> {
                if (isImport) {
                    ImpexImportHmsContext.get().addDatastoreInfo(dsIdWithVcId, (Datastore.Info)info);
                } else {
                    ImpexExportHmsContext.get().addDatastoreInfo(dsIdWithVcId, (Datastore.Info)info);
                }
                return info;
            });
        }
        return Promises.resolve((Object)dsInfo);
    }

    private static Promise<Datastore.Info> getDatastoreInfo(Datastore ds) {
        FuturePromise infoPromise = new FuturePromise();
        ds.getInfo((Future)infoPromise);
        return infoPromise.onError(e -> LOGGER.error("Failed to get datastore info for '{}':", (Object)ds._getRef().getValue(), e));
    }

    public static Promise<String> getDatastoreType(VcServer vcServer, String datastoreId) {
        VcService vcService = (VcService)vcServer.service();
        Datastore ds = (Datastore)vcService.createStub(new ManagedObjectReference(HmsUtil.getVmodlTypeName(Datastore.class), datastoreId));
        return DataStoreUtil.getDatastoreSummary(ds).thenApply(summary -> {
            switch (summary.getType().toUpperCase()) {
                case "VSAN": 
                case "VVOL": 
                case "VMFS": 
                case "NFS": 
                case "NFS41": {
                    return summary.getType().toUpperCase();
                }
            }
            throw new RuntimeException("Unexpected datastore type. " + String.format("The datastore type should be [%s] [%s] [%s] [%s] [%s]", DATASTORE_NFS_TYPE, DATASTORE_VMFS_TYPE, DATASTORE_VSAN_TYPE, DATASTORE_VVOL_TYPE, DATASTORE_NFS41_TYPE));
        });
    }

    private static Promise<Datastore.Summary> getDatastoreSummary(Datastore ds) {
        FuturePromise dsSummary = new FuturePromise();
        ds.getSummary((Future)dsSummary);
        return dsSummary.onError(e -> LOGGER.error("Failed to get datastore summary for '{}': ", (Object)ds._getRef(), e));
    }

    private static Promise<String> getObjectFriendlyNameInNewVsanAndVvol(VcService vcService, Datastore ds, Datastore.Info dsInfo, String path) {
        String[] splittedPath = path.split("/");
        Object searchPath = String.format("[%s]", dsInfo.getName());
        Object parentPath = "";
        ArrayList<Promise<DatastoreBrowser.FileInfo>> fileInfoList = new ArrayList<Promise<DatastoreBrowser.FileInfo>>();
        for (String subPath : splittedPath) {
            searchPath = (String)searchPath + (String)parentPath;
            fileInfoList.add(DataStoreUtil.searchDatastore(vcService, (String)searchPath, subPath, ds._getRef()));
            parentPath = subPath + "/";
        }
        return Promises.all((Promise[])fileInfoList.toArray(new Promise[fileInfoList.size()])).thenApply(resultAccessor -> {
            ArrayList<String> friendlyNameList = new ArrayList<String>();
            for (Promise promise : fileInfoList) {
                DatastoreBrowser.FileInfo fileInfo = (DatastoreBrowser.FileInfo)resultAccessor.getResult(promise);
                if (fileInfo == null) {
                    throw new RuntimeException("Cannot get the datastore info in vc " + String.valueOf(vcService.getGuid()) + " within datastore : " + String.valueOf(ds._getRef()) + " with folder path : " + path);
                }
                if (fileInfo.getFriendlyName() == null) {
                    friendlyNameList.add(fileInfo.getPath());
                    continue;
                }
                friendlyNameList.add(fileInfo.getFriendlyName());
            }
            return String.join((CharSequence)"/", friendlyNameList);
        });
    }

    public static Promise<Boolean> fileExists(VcServer vcServer, ManagedObjectReference dsRef, String filePath, String fileName, boolean isImport) {
        VcService vcService = (VcService)vcServer.service();
        Datastore ds = (Datastore)vcService.createStub(dsRef);
        Promise<Datastore.Info> dsInfoPromise = DataStoreUtil.getDatastoreInfoWithCache(vcServer.guid(), ds, isImport);
        return dsInfoPromise.thenCompose(dsInfo -> {
            Promise dsBrowserPromise = PCUtil.retrieveProperty((ServersView)ImpexImportHmsContext.get().getServersDataWrapper().getView(), (ManagedObjectReference)ds._getRef(), (String)"browser");
            String searchPath = String.format("[%s] %s/", dsInfo.getName(), filePath);
            return dsBrowserPromise.thenCompose(dsBrowserRef -> {
                DatastoreBrowser dsBrowser = (DatastoreBrowser)vcService.createStub(dsBrowserRef);
                FuturePromise fp = new FuturePromise();
                ArrayList<DatastoreBrowser.Query> queries = new ArrayList<DatastoreBrowser.Query>();
                queries.add((DatastoreBrowser.Query)new DatastoreBrowser.FolderQuery());
                queries.add(new DatastoreBrowser.Query());
                dsBrowser.search(searchPath, DataStoreUtil.createSearchSpec(queries, fileName), (Future)fp);
                return fp.thenCompose(taskRef -> TaskUtil.waitForTaskToFinish((Service)vcService, (ManagedObjectReference)taskRef));
            }).materialize().thenApply(task -> {
                if (!task.isSuccessful()) {
                    LOGGER.error("Failed to search file {} in {}: ", new Object[]{filePath, searchPath, task.getError()});
                    return Boolean.FALSE;
                }
                Object taskResult = task.getResult();
                DatastoreBrowser.SearchResults[] typedResults = taskResult instanceof DatastoreBrowser.SearchResults[] ? (DatastoreBrowser.SearchResults[])taskResult : (taskResult instanceof DatastoreBrowser.SearchResults ? new DatastoreBrowser.SearchResults[]{(DatastoreBrowser.SearchResults)taskResult} : new DatastoreBrowser.SearchResults[]{});
                DatastorePathUtil.unescapeDatastoreNameInSearchResults((DatastoreBrowser.SearchResults[])typedResults);
                List<DatastoreBrowser.SearchResults> searchResults = Arrays.asList(typedResults);
                return searchResults.stream().anyMatch(result -> result.file != null);
            });
        });
    }
}

