/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.workflow;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.tuple.Tuple2;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsPairSetup;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServersView;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.srm.client.topology.impl.core.operations.faults.ProviderNotAuthenticatedException;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.ServersDataWrapper;
import com.vmware.vr.client.impex.workflow.TopologyCreator;
import com.vmware.vr.client.impex.workflow.UserInteractor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HmsTopologyCreator
extends TopologyCreator {
    static HmsTopologyCreator instance = new HmsTopologyCreator();

    public static TopologyCreator getInstance() {
        return instance;
    }

    private HmsTopologyCreator() {
    }

    @Override
    public Promise<PairSetup> selectServerPair(TopologyImpl topology) {
        return HmsTopologyCreator.promptForRemoteHms(topology).thenCompose(remoteGuid -> HmsTopologyCreator.promptForLocalHms(topology, remoteGuid).thenCombineCompose(Promises.resolve((Object)remoteGuid), (local, remote) -> HmsTopologyCreator.loginRemote(topology, local, remote).thenCompose(rGuid -> HmsTopologyCreator.doRemoteSiteLogin((Topology)topology, local, remote).thenCombine(HmsTopologyCreator.doRemoteSiteLogin((Topology)topology, remote, local), (u1, u2) -> topology).thenCompose(unused -> ((HmsServersView)topology.getView()).getHmsBy(local).thenCompose(hmsServer -> hmsServer.getPairByGuid(rGuid))))));
    }

    private static Promise<String> promptForLocalHms(TopologyImpl topology, String remoteGuid) {
        return HmsTopologyCreator.buildLocalHmsByGuid((HmsServersView)topology.getView(), remoteGuid).thenCompose(map -> {
            if (map.isEmpty()) {
                return Promises.reject((Exception)new RuntimeException("No VR servers available."));
            }
            return UserInteractor.getInputWaiter().promptForLocalHmsServer((Map<String, String>)map);
        });
    }

    private static Promise<String> promptForRemoteHms(TopologyImpl topology) {
        return HmsTopologyCreator.buildRemoteHmsByGuid((HmsServersView)topology.getView()).thenCompose(map -> {
            if (map.isEmpty()) {
                return Promises.reject((Exception)new RuntimeException("No VR servers available."));
            }
            return UserInteractor.getInputWaiter().promptForRemoteHmsServer((Map<String, String>)map);
        });
    }

    private static Promise<String> loginRemote(TopologyImpl topology, String localHmsGuid, String remoteHmsGuid) {
        return ((HmsServersView)topology.getView()).getHmsBy(localHmsGuid).thenCompose(hmsServer -> hmsServer.getPairByGuid(remoteHmsGuid)).thenCompose(pairSetup -> pairSetup.getPairServer().materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)((HmsServer)pr.getResult()).guid());
            }
            if (!(pr.getError() instanceof PairSetup.PairSetupException)) {
                return Promises.reject((Exception)pr.getError());
            }
            PairSetup.PairSetupException pse = (PairSetup.PairSetupException)pr.getError();
            if (!(pse.getCause() instanceof ProviderNotAuthenticatedException)) {
                return Promises.reject((Exception)pr.getError());
            }
            Promise loginRemotePromise = UserInteractor.getInputWaiter().promptForUsingRemoteServiceAccount(pairSetup.pairServerName()).thenCompose(useRemoteSA -> useRemoteSA != false ? HmsTopologyCreator.loginRemoteWithSA(topology, (PairSetup)pairSetup) : HmsTopologyCreator.loginRemoteWithCreds(topology, (PairSetup)pairSetup));
            return loginRemotePromise.materialize().thenCompose(innerPr -> {
                if (innerPr.isSuccessful()) {
                    return Promises.resolve((Object)remoteHmsGuid);
                }
                Exception innerCause = innerPr.getError();
                if (innerCause instanceof Topology.LoginFailedException) {
                    UserInteractor.getIoHelper().writeln("Invalid credentials.");
                    return HmsTopologyCreator.loginRemote(topology, localHmsGuid, remoteHmsGuid);
                }
                return Promises.reject((Exception)new RuntimeException("Remote login failed.", innerCause));
            });
        }));
    }

    private static Promise<Void> doRemoteSiteLogin(Topology topology, String localGuid, String remoteGuid) {
        return ((HmsServersView)topology.getView()).getHmsBy(localGuid).thenCompose(hmsServer -> hmsServer.getPairByGuid(remoteGuid)).thenCompose(PairSetup::remoteLogin);
    }

    private static Promise<Map<String, String>> buildLocalHmsByGuid(HmsServersView serversView, String remoteHmsGuid) {
        return serversView.getLocalHmsServers().flatMap(hmsServer -> HmsTopologyCreator.from(hmsServer.getPairByGuid(remoteHmsGuid))).filter(Objects::nonNull).map(PairSetup::server).flatMap(hms -> HmsTopologyCreator.from(hms.getName().thenApply(name -> new Tuple2((Object)hms.guid(), name)))).reduce(new HashMap(), (map, tuple) -> {
            map.put((String)tuple.getFirst(), (String)tuple.getSecond());
            return map;
        });
    }

    private static Promise<Map<String, String>> buildRemoteHmsByGuid(HmsServersView localServersView) {
        return localServersView.getLocalHmsServers().flatMap(hmsServer -> HmsTopologyCreator.from(hmsServer.getPairs())).filter(Objects::nonNull).reduce(new HashMap(), (map, hmsPairSetup) -> {
            map.put(hmsPairSetup.pairServerGuid(), hmsPairSetup.pairServerName());
            return map;
        });
    }

    public static Promise<ServersDataWrapper> createWrapper(TopologyImpl topology, PairSetup<HmsServer> pairSetup) {
        UserInteractor.getIoHelper().writeln("Collecting data...");
        HmsServersView view = (HmsServersView)topology.getView();
        Promise remoteServerPromise = pairSetup.getPairServer();
        return remoteServerPromise.thenCompose(remoteServer -> remoteServer.getPairByGuid(((HmsServer)pairSetup.server()).guid()).thenCompose(remotePair -> HmsTopologyCreator.getHmsServersData(view, (HmsPairSetup)pairSetup, remotePair)));
    }

    private static Promise<HmsServersDataWrapper> getHmsServersData(HmsServersView view, HmsPairSetup localPair, HmsPairSetup remotePair) {
        HmsServer localHmsServer = (HmsServer)localPair.server();
        Promise localContentPromise = ((HmsService)localHmsServer.service()).getContent();
        HmsServer remoteHmsServer = (HmsServer)remotePair.server();
        Promise remoteContentPromise = ((HmsService)remoteHmsServer.service()).getContent();
        return localContentPromise.thenCombine(remoteContentPromise, (localContent, remoteContent) -> new HmsServersDataWrapper(view, localPair, remotePair, (ServiceInstanceContent)localContent, (ServiceInstanceContent)remoteContent));
    }
}

