/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.common.impl.ManagedObjectFactoryImpl;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfigurationCompiler;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpAsyncConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.CompiledHttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncConfigurationCompilerImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpAsyncProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpClient;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationCompilerImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingBase;
import com.vmware.vim.vmomi.client.http.impl.HttpProtocolBindingImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpSchemeUtils;
import com.vmware.vim.vmomi.client.version.VersionProvider;
import com.vmware.vim.vmomi.client.version.impl.StaticVersionProvider;
import com.vmware.vim.vmomi.core.tracing.GlobalTelemetry;
import com.vmware.vim.vmomi.core.tracing.Tracer;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.net.URI;
import java.util.concurrent.CompletionStage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientFactory {
    private static final Log LOG = LogFactory.getLog(ClientFactory.class);

    public static Client createClient(URI endPoint, Class<?> version, ClientConfiguration config, VmodlContext context) {
        return ClientFactory.createClient(endPoint, ClientFactory.resolveVersion(version, config, context), config, context);
    }

    private static VersionProvider resolveVersion(Class<?> version, ClientConfiguration config, VmodlContext context) {
        if (version == null) {
            return config.getVersionProvider();
        }
        return new StaticVersionProvider(version, context);
    }

    public static Client createClient(URI endPoint, VersionProvider versionProvider, ClientConfiguration config, VmodlContext context) {
        if (versionProvider == null) {
            throw new IllegalArgumentException("VersionProvider must be specified");
        }
        if (!(config instanceof HttpClientConfiguration)) {
            throw new IllegalArgumentException("Unknow client configuration type: " + config.getClass());
        }
        HttpClientConfiguration httpConfig = (HttpClientConfiguration)config;
        if (httpConfig.getHttpConfiguration().getNonBlockingIo()) {
            return ClientFactory.createHttpAsyncClient(endPoint, versionProvider, httpConfig, context);
        }
        return ClientFactory.createHttpClient(endPoint, versionProvider, httpConfig, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient createHttpClient(URI endPoint, VersionProvider versionProvider, HttpClientConfiguration config, VmodlContext context) {
        ClientFactory.validate(config, endPoint);
        HttpConfigurationCompiler compiler = config.getHttpConfigurationCompiler() == null ? new HttpConfigurationCompilerImpl() : config.getHttpConfigurationCompiler();
        HttpConfiguration httpConfiguration = config.getHttpConfiguration();
        synchronized (httpConfiguration) {
            CompiledHttpConfiguration compiledConfig = compiler.compile(config);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating HTTP client with following properties:\nEnd point: " + endPoint + "\nThread pool: " + config.getExecutor() + "\nResult interceptor: " + config.getResulInterceptor()));
            }
            HttpProtocolBindingImpl binding = new HttpProtocolBindingImpl(endPoint, config.getExecutor(), config.getServerEndpointProvider(), config.getHttpConfiguration(), ClientFactory.getTracer(config));
            HttpClient client = ClientFactory.createClient(binding, config, versionProvider, context);
            compiledConfig.reserve(client);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient createHttpAsyncClient(URI endPoint, VersionProvider versionProvider, HttpClientConfiguration config, VmodlContext context) {
        ClientFactory.validate(config, endPoint);
        HttpConfigurationCompiler compiler = config.getHttpConfigurationCompiler() == null ? new HttpAsyncConfigurationCompilerImpl() : config.getHttpConfigurationCompiler();
        HttpConfiguration httpConfiguration = config.getHttpConfiguration();
        synchronized (httpConfiguration) {
            CompiledHttpConfiguration compiledConfig = compiler.compile(config);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating HTTP async client with following properties:\nEnd point: " + endPoint + "\nThread pool: " + config.getExecutor() + "\nI/O thread pool: " + config.getHttpConfiguration().getNioThreadPoolSize() + "\nResult interceptor: " + config.getResulInterceptor()));
            }
            HttpAsyncProtocolBindingImpl binding = new HttpAsyncProtocolBindingImpl(endPoint, config.getExecutor(), config.getServerEndpointProvider(), config.getHttpConfiguration(), ClientFactory.getTracer(config));
            HttpClient client = ClientFactory.createClient(binding, config, versionProvider, context);
            compiledConfig.reserve(client);
            return client;
        }
    }

    private static void validate(HttpClientConfiguration config, URI endPoint) {
        if (!(endPoint == null ^ config.getServerEndpointProvider() == null)) {
            throw new IllegalStateException("Invalid endpoint configuration - either static URI or dynamic server URI provider must be configured.");
        }
        if (endPoint != null && !HttpSchemeUtils.checkSchema(endPoint)) {
            throw new IllegalStateException("Unknown scheme " + endPoint.getScheme());
        }
        boolean sync = !config.getHttpConfiguration().getNonBlockingIo();
        CompiledHttpConfiguration compiledConfig = ((HttpConfigurationImpl)config.getHttpConfiguration()).getCompiledConfiguration();
        if (compiledConfig != null && compiledConfig.isActive()) {
            if (sync && !(compiledConfig instanceof CompiledHttpConfigurationImpl)) {
                throw new IllegalArgumentException("Configuration used for async clients can not be used for sync clients");
            }
            if (!sync && !(compiledConfig instanceof CompiledHttpAsyncConfigurationImpl)) {
                throw new IllegalArgumentException("Configuration used for sync clients can not be used for async clients");
            }
        } else {
            if (config.getHttpConfiguration() == null) {
                throw new IllegalArgumentException("Client HTTP configuration is required");
            }
            HttpConfigurationCompiler compiler = config.getHttpConfigurationCompiler();
            if (compiler != null && (sync && !(compiler instanceof HttpConfigurationCompilerImpl) || !sync && !(compiler instanceof HttpAsyncConfigurationCompilerImpl))) {
                throw new IllegalArgumentException("Please, provide correct type of configuration compiler");
            }
        }
    }

    private static HttpClient createClient(final HttpProtocolBindingBase binding, ClientConfiguration config, VersionProvider versionProvider, final VmodlContext context) {
        binding.setInvocationInterceptor(config.getInvocationInterceptor());
        CompletionStage<VmodlVersion> version = versionProvider.getVersionAsync(new VersionProvider.GetVersionSpec(){

            @Override
            public VmodlContext getContext() {
                return context;
            }

            @Override
            public ProtocolBinding getProtocolBinding() {
                return binding;
            }
        });
        HttpClient client = new HttpClient(version, binding, config.getManagedObjectFactory() == null ? new ManagedObjectFactoryImpl(binding, config.getRequestContext(), config.getResulInterceptor(), config.getRequestRetryCallback(), config.getAsyncRequestRetryCallback(), config.getRequestContextProvider(), config.getRequestConfigurationProvider(), context) : config.getManagedObjectFactory(), context);
        return client;
    }

    private static Tracer getTracer(ClientConfiguration config) {
        Tracer tracer = config.getTracer();
        if (tracer != null) {
            return tracer;
        }
        return GlobalTelemetry.getTracer();
    }
}

