/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.configurables.inventory;

import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.vim.VIRTUAL_MACHINE;
import com.vmware.vr.client.impex.configurables.ConfigurableConverter;
import com.vmware.vr.client.impex.configurables.inventory.IeInventory;
import com.vmware.vr.client.impex.configurables.inventory.IeInventoryFolder;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.ComputeResourceConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.DatacenterConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.StoragePodConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.VirtualAppConverter;
import com.vmware.vr.client.impex.configurables.inventory.datacenter.VirtualMachineConverter;
import com.vmware.vr.client.impex.tool.IdBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryConverter.class);

    public static ManagedObjectReference getRootFolder(String serverGuid) {
        return ClientUtils.createMoRef((String)"Folder", (String)"group-d1", (String)serverGuid);
    }

    public static PropertyCollector.FilterSpec getFilterSpec(String vcGuid) {
        PropertyCollector.PropertySpec vmPropertySpec = PCUtil.createPropertySpec((String)"VirtualMachine", (String[])new String[]{"name", VIRTUAL_MACHINE.CONFIG_.INSTANCE_UUID});
        PropertyCollector.PropertySpec folderPropertySpec = PCUtil.createPropertySpec((String)"Folder", (String[])new String[]{"name", "childEntity"});
        PropertyCollector.PropertySpec dcPropertySpec = PCUtil.createPropertySpec((String)"Datacenter", (String[])new String[]{"name", "vmFolder", "network", "datastore", "datastoreFolder", "hostFolder"});
        PropertyCollector.PropertySpec networkPropertySpec = PCUtil.createPropertySpec((String)"Network", (String[])new String[]{"name", "tag"});
        PropertyCollector.PropertySpec datastorePropertySpec = PCUtil.createPropertySpec((String)"Datastore", (String[])new String[]{"name"});
        PropertyCollector.PropertySpec computeResourcePropertySpec = PCUtil.createPropertySpec((String)"ComputeResource", (String[])new String[]{"name", "host", "resourcePool"});
        PropertyCollector.PropertySpec hostSystemPropertySpec = PCUtil.createPropertySpec((String)"HostSystem", (String[])new String[]{"name"});
        PropertyCollector.PropertySpec resourcePoolPropertySpec = PCUtil.createPropertySpec((String)"ResourcePool", (String[])new String[]{"name", "resourcePool", "vm"});
        PropertyCollector.PropertySpec storagePodPropertySpec = PCUtil.createPropertySpec((String)"StoragePod", (String[])new String[]{"name", "childEntity"});
        ManagedObjectReference rootFolder = InventoryConverter.getRootFolder(vcGuid);
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(rootFolder);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = specBuilder.traverseTo("childEntity");
        ObjectSpecBuilder.TraversalSpecBuilder dcTraversal = rootTraversal.traverseTo("Datacenter", "vmFolder");
        ObjectSpecBuilder.TraversalSpecBuilder networkTraversal = rootTraversal.traverseTo("Datacenter", "network");
        ObjectSpecBuilder.TraversalSpecBuilder datastoreTraversal = rootTraversal.traverseTo("Datacenter", "datastore");
        ObjectSpecBuilder.TraversalSpecBuilder computeResourceTraversal = rootTraversal.traverseTo("Datacenter", "hostFolder");
        ObjectSpecBuilder.TraversalSpecBuilder hostSystemTraversal = rootTraversal.traverseTo("ComputeResource", "host");
        ObjectSpecBuilder.TraversalSpecBuilder datastoreFolderTraversal = rootTraversal.traverseTo("Datacenter", "datastoreFolder");
        ObjectSpecBuilder.TraversalSpecBuilder storagePodTraversal = datastoreFolderTraversal.traverseTo("StoragePod", "childEntity");
        ObjectSpecBuilder.TraversalSpecBuilder computeResourcePoolTraversal = rootTraversal.traverseTo("ComputeResource", "resourcePool");
        ObjectSpecBuilder.TraversalSpecBuilder resourcePoolPoolTraversal = computeResourcePoolTraversal.traverseTo("ResourcePool", "resourcePool");
        resourcePoolPoolTraversal.traverseTo("ResourcePool", "vm");
        rootTraversal.loopTo(rootTraversal.getName());
        rootTraversal.loopTo(dcTraversal.getName());
        rootTraversal.loopTo(networkTraversal.getName());
        rootTraversal.loopTo(datastoreTraversal.getName());
        rootTraversal.loopTo(computeResourceTraversal.getName());
        rootTraversal.loopTo(computeResourcePoolTraversal.getName());
        rootTraversal.loopTo(resourcePoolPoolTraversal.getName());
        rootTraversal.loopTo(datastoreFolderTraversal.getName());
        rootTraversal.loopTo(storagePodTraversal.getName());
        dcTraversal.loopTo(rootTraversal.getName());
        networkTraversal.loopTo(rootTraversal.getName());
        datastoreTraversal.loopTo(rootTraversal.getName());
        computeResourceTraversal.loopTo(rootTraversal.getName());
        computeResourcePoolTraversal.loopTo(rootTraversal.getName());
        hostSystemTraversal.loopTo(rootTraversal.getName());
        datastoreFolderTraversal.loopTo(rootTraversal.getName());
        storagePodTraversal.loopTo(rootTraversal.getName());
        computeResourcePoolTraversal.loopTo(computeResourcePoolTraversal.getName());
        resourcePoolPoolTraversal.loopTo(resourcePoolPoolTraversal.getName());
        datastoreFolderTraversal.loopTo(storagePodTraversal.getName());
        storagePodTraversal.loopTo(datastoreFolderTraversal.getName());
        return new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{vmPropertySpec, folderPropertySpec, dcPropertySpec, networkPropertySpec, datastorePropertySpec, computeResourcePropertySpec, hostSystemPropertySpec, resourcePoolPropertySpec, storagePodPropertySpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
    }

    public static IeInventoryFolder rootFromVmodl(IdBuilder idBuilder, PcResult pcResult, String vcGuid) {
        IeInventoryFolder ieRoot = new IeInventoryFolder();
        ieRoot.setId(idBuilder.buildRootFolderId(vcGuid));
        if (pcResult == null || vcGuid == null) {
            return ieRoot;
        }
        ManagedObjectReference root = InventoryConverter.getRootFolder(vcGuid);
        ieRoot.setName((String)pcResult.getProperty(root, root.getValue()));
        ieRoot.setChildren(InventoryConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference[])pcResult.getProperty(root, "childEntity")));
        return ieRoot;
    }

    public static List<IeInventory> fromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference[] entities) {
        if (ArrayUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        return Arrays.stream(entities).map(entity -> {
            switch (entity.getType()) {
                case "Folder": {
                    return InventoryConverter.folderFromVmodl(idBuilder, pcResult, entity);
                }
                case "VirtualMachine": {
                    return VirtualMachineConverter.fromVmodl(idBuilder, pcResult, entity);
                }
                case "Datacenter": {
                    return DatacenterConverter.fromVmodl(idBuilder, pcResult, entity);
                }
                case "ComputeResource": 
                case "ClusterComputeResource": {
                    return ComputeResourceConverter.fromVmodl(idBuilder, pcResult, entity);
                }
                case "VirtualApp": {
                    return VirtualAppConverter.fromVmodl(idBuilder, pcResult, entity);
                }
                case "StoragePod": {
                    return StoragePodConverter.fromVmodl(idBuilder, pcResult, entity);
                }
            }
            LOGGER.warn("Unexpected entity type: {}.", entity);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static IeInventoryFolder folderFromVmodl(IdBuilder idBuilder, PcResult pcResult, ManagedObjectReference entity) {
        IeInventoryFolder folder = new IeInventoryFolder();
        folder.setName((String)pcResult.getProperty(entity, "name"));
        folder.setId(idBuilder.buildId(entity));
        folder.setChildren(InventoryConverter.fromVmodl(idBuilder, pcResult, (ManagedObjectReference[])pcResult.getProperty(entity, "childEntity")));
        return folder;
    }
}

