/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.utils;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.vim.binding.hms.ReplicationManager;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vim.binding.hms.remote.SiteManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidType;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmsUtil.class);

    public static Promise<ManagedObjectReference> getHbrSrvByName(HmsService localHmsService, ServiceInstanceContent localServiceContent, String name) {
        SiteManager siteManager = (SiteManager)localHmsService.createStub(localServiceContent.getSiteManager());
        FuturePromise hbrsrvPromise = new FuturePromise();
        siteManager.findHbrServer(name, (Future)hbrsrvPromise);
        return hbrsrvPromise;
    }

    public static Promise<ReplicationManager.VmInfoPage> getVmInfoPage(ReplicationManager replicationManager, ManagedObjectReference remoteHmsRef, int startIndex, int count) {
        FuturePromise vmInfoPageFP = new FuturePromise();
        replicationManager.getVmInfoPage(remoteHmsRef, startIndex, count, (Future)vmInfoPageFP);
        return vmInfoPageFP.onError(e -> LOGGER.error("Failed to get vm info page: ", (Throwable)e));
    }

    public static String getVmodlTypeName(Class<?> clasz) {
        wsdlName vmodlTypeName = clasz.getAnnotation(wsdlName.class);
        return Optional.ofNullable(vmodlTypeName).map(typeName -> typeName.value()).orElseThrow(() -> new InvalidType(clasz.getName()));
    }
}

