/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.remotelogin;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.srm.client.infrastructure.authentication.SessionWrapper;
import com.vmware.srm.client.infrastructure.http.BaseAsyncController;
import com.vmware.srm.client.infrastructure.oauth2.OAuth2VapiUtils;
import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmPairSetup;
import com.vmware.srm.client.topology.impl.core.TopologyImpl;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.sso.external.jwt.JwtUtils;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLoginEndpointServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginEndpointServlet.class);

    public static Topology getTopology(HttpServletRequest request) {
        TopologyImpl topology;
        Validate.notNull((Object)request, (String)"request");
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        try {
            topology = SessionWrapper.getTopology(session);
        }
        catch (IllegalStateException exc) {
            return null;
        }
        if (topology == null || !topology.isAuthenticated()) {
            return null;
        }
        return topology;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Date expireDate;
        Topology topology = RemoteLoginEndpointServlet.getTopology(request);
        if (topology == null) {
            response.sendError(401);
            return;
        }
        String requestId = request.getParameter("requestid");
        if (requestId == null) {
            LOGGER.warn("No {} parameter in request", (Object)"requestid");
            response.sendError(400);
            return;
        }
        Topology.RemoteLoginServerData loginData = topology.getRemoteLoginServer(requestId);
        if (loginData == null) {
            LOGGER.warn("No server guid found for request id {}", (Object)requestId);
            response.sendError(400);
            return;
        }
        String serverGuid = loginData.getPairServerGuid();
        String redirectUrl = loginData.getRedirectUrl();
        String base64Token = request.getParameter("samltoken");
        if (base64Token == null) {
            LOGGER.warn("No saml token found for request id {}", (Object)requestId);
            response.sendError(400);
            return;
        }
        String samlTokenAsXml = new String(Base64.getDecoder().decode(base64Token));
        String refreshToken = request.getParameter("refreshtoken");
        if (refreshToken == null) {
            LOGGER.warn("No refresh token found for request id {}", (Object)requestId);
            response.sendError(400);
            return;
        }
        try {
            expireDate = JwtUtils.getExpClaim((String)refreshToken);
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to extract expire date for request id {}", (Object)requestId, (Object)exc);
            response.sendError(400);
            return;
        }
        if (expireDate.before(new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L)))) {
            LOGGER.warn("Expired or about to expire refresh token: {}", (Object)expireDate);
            response.sendError(400);
            return;
        }
        RemoteLoginController controller = new RemoteLoginController(request, response, topology, requestId, serverGuid, redirectUrl, samlTokenAsXml, refreshToken, expireDate);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class RemoteLoginController
    extends BaseAsyncController {
        private final Topology _topology;
        private final String _requestId;
        private final String _serverGuid;
        private final String _redirectUrl;
        private final String _samlTokenAsXml;
        private final String _refreshToken;
        private final Date _expireDate;

        public RemoteLoginController(HttpServletRequest request, HttpServletResponse response, Topology topology, String requestId, String serverGuid, String redirectUrl, String samlTokenAsXml, String refreshToken, Date expireDate) {
            super(request, response);
            this._topology = topology;
            this._requestId = requestId;
            this._serverGuid = serverGuid;
            this._redirectUrl = redirectUrl;
            this._samlTokenAsXml = samlTokenAsXml;
            this._refreshToken = refreshToken;
            this._expireDate = expireDate;
        }

        @Override
        protected BaseAsyncController.HttpProcessStage createPipeline() {
            return this::getPairSetup;
        }

        Stream<BaseAsyncController.HttpProcessStage> getPairSetup() {
            return this._topology.getView().getServerBy(this._serverGuid).materialize().thenCompose(pr -> {
                if (pr.isSuccessful()) {
                    return Promises.resolve(null);
                }
                if (pr.getError() instanceof ExtensionServersView.ServerByPairSetupException) {
                    ExtensionServersView.ServerByPairSetupException sbpsExc = (ExtensionServersView.ServerByPairSetupException)pr.getError();
                    PairSetup<?> ps = this.pick(sbpsExc);
                    if (ps == null) {
                        return Promises.reject((Exception)new RuntimeException(L10N.localize("noEligiblePairSetup", this._serverGuid)));
                    }
                    return Promises.resolve(ps);
                }
                return Promises.reject((Exception)pr.getError());
            }).toStream().flatMap(ps -> {
                if (ps == null) {
                    try {
                        this._response.sendRedirect(this._redirectUrl);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to send redirect.", (Throwable)e);
                        return Promises.reject((Exception)e);
                    }
                    return Streams.empty();
                }
                return Streams.just((Object[])new BaseAsyncController.HttpProcessStage[]{() -> this.validateSamlToken((PairSetup<?>)ps)});
            });
        }

        Stream<BaseAsyncController.HttpProcessStage> validateSamlToken(PairSetup<?> ps) {
            PairSetupImpl psImpl = (PairSetupImpl)ps;
            return SsoUtils.createSamlToken((String)this._samlTokenAsXml, (URI)psImpl.pairLsppUrl(), (String)psImpl.pairLsppThumbprint()).thenApply(samlToken -> () -> this.createRefreshData(ps, (SamlToken)samlToken)).toStream();
        }

        Stream<BaseAsyncController.HttpProcessStage> createRefreshData(PairSetup<?> ps, SamlToken samlToken) {
            PairSetupImpl psImpl = (PairSetupImpl)ps;
            Promise vmomiEp = ps instanceof SrmPairSetup ? OAuth2VapiUtils.getSrmByGuid(psImpl.pairLsppUrl(), psImpl.pairLsppThumbprint(), psImpl.pairServerGuid()).thenApply(srmReg -> Objects.requireNonNull(LsppHelper.getVmomiEndpoint((LsppService)srmReg, (String)"com.vmware.dr.vcDr"), "No srm vmomi endpoint")) : OAuth2VapiUtils.getHmsByGuid(psImpl.pairLsppUrl(), psImpl.pairLsppThumbprint(), psImpl.pairServerGuid()).thenApply(hmsReg -> Objects.requireNonNull(LsppHelper.getVmomiEndpoint((LsppService)hmsReg, (String)"com.vmware.vim.hms"), "No hms vmomi endpoint"));
            return vmomiEp.thenApply(ep -> {
                URI url;
                KeyStore store;
                try {
                    store = CertificateUtils.createTrustStore((Collection)ep.getCertificates());
                }
                catch (Exception e) {
                    throw Exceptions.getRuntimeException((Throwable)e);
                }
                try {
                    url = Config.getAppBaseUrl((String)ep.url.getScheme(), (String)ep.url.getHost(), (int)Config.get().getAppUrl().getPort(), (String)"/dr/remotelogin/oauth2/refresh");
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                SslTrust.TrustData trustData = SslTrust.get((KeyStore)store);
                RefreshDataImpl refreshData = new RefreshDataImpl(url, (ThumbprintVerifier)trustData.first(), (KeyStore)trustData.second(), this._expireDate, this._refreshToken);
                return () -> this.remoteLogin(ps, samlToken, refreshData);
            }).toStream();
        }

        Stream<BaseAsyncController.HttpProcessStage> remoteLogin(PairSetup<?> ps, SamlToken samlToken, TokenProvider.RefreshData loginData) {
            return this._topology.loginPair(this._requestId, ps, samlToken, loginData).toStream().flatMap(unused -> {
                try {
                    this._response.sendRedirect(this._redirectUrl);
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to send redirect.", (Throwable)e);
                    return Promises.reject((Exception)e);
                }
                return Streams.empty();
            });
        }

        private PairSetup<?> pick(ExtensionServersView.ServerByPairSetupException sbpsExc) {
            PairSetup pairSetup = sbpsExc.getPairSetups().stream().filter(ps -> this._serverGuid.equals(ps.pairServerGuid())).findFirst().orElse(null);
            if (sbpsExc.getCause(pairSetup) instanceof NotAuthenticated) {
                return pairSetup;
            }
            return null;
        }
    }

    private static final class RefreshDataImpl
    implements TokenProvider.RefreshData {
        private final URI _url;
        private final ThumbprintVerifier _verifier;
        private final KeyStore _trustStore;
        private final Date _expireDate;
        private final String _refreshToken;

        private RefreshDataImpl(URI url, ThumbprintVerifier verifier, KeyStore trustStore, Date expireDate, String refreshToken) {
            this._url = url;
            this._verifier = verifier;
            this._trustStore = trustStore;
            this._expireDate = expireDate;
            this._refreshToken = refreshToken;
        }

        public URI getUrl() {
            return this._url;
        }

        public ThumbprintVerifier getVerifier() {
            return this._verifier;
        }

        public KeyStore getTrustStore() {
            return this._trustStore;
        }

        public Date getGetExpiresAt() {
            return this._expireDate;
        }

        public String getRefreshToken() {
            return this._refreshToken;
        }
    }
}

