/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.pc.utils;

import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcResultImpl
implements PcResult {
    private static final Logger LOGGER = LoggerFactory.getLogger(PcResultImpl.class);
    final Map<String, Exception> _guidToError = new HashMap<String, Exception>();
    final Set<ManagedObjectReference> _moRefs = new HashSet<ManagedObjectReference>();
    final Set<ManagedObjectReference> _moRefsInResult = new HashSet<ManagedObjectReference>();
    final Map<ManagedObjectReference, Map<String, Object>> _moRefToProps = new HashMap<ManagedObjectReference, Map<String, Object>>();
    final Map<ManagedObjectReference, Map<String, Exception>> _moRefToMissingProps = new HashMap<ManagedObjectReference, Map<String, Exception>>();
    final Map<ManagedObjectReference, Exception> _moRefToError = new HashMap<ManagedObjectReference, Exception>();

    public PcResultImpl(Collection<ManagedObjectReference> moRefs) {
        Validate.notNull(moRefs, (String)"moRefs");
        if (!moRefs.isEmpty()) {
            this._moRefs.addAll(moRefs);
        }
    }

    public void addMoRef(ManagedObjectReference moRef) {
        Validate.notNull((Object)moRef, (String)"moRef");
        this._moRefs.add(moRef);
    }

    public void addMoRefInResult(ManagedObjectReference moRef) {
        Validate.notNull((Object)moRef, (String)"moRef");
        this._moRefsInResult.add(moRef);
    }

    public void addGeneralError(String guid, Exception ex) {
        Validate.notEmpty((String)guid, (String)"guid");
        Validate.notNull((Object)ex, (String)"ex");
        this._guidToError.put(guid, ex);
    }

    public void addMoRefError(ManagedObjectReference moRef, Exception ex) {
        Validate.notNull((Object)moRef, (String)"moRef");
        Validate.notNull((Object)ex, (String)"ex");
        Validate.isTrue((boolean)this._moRefs.contains(moRef), (String)(moRef + " is not part of the request."));
        this._moRefToError.put(moRef, ex);
    }

    public void addPropertyError(ManagedObjectReference moRef, String propName, Exception ex) {
        Validate.notNull((Object)moRef, (String)"moRef");
        Validate.notEmpty((String)propName, (String)"propName");
        Validate.notNull((Object)ex, (String)"ex");
        Validate.isTrue((boolean)this._moRefs.contains(moRef), (String)(moRef + " is not part of the request."));
        Map<String, Exception> propErrorMap = this._moRefToMissingProps.get(moRef);
        if (propErrorMap == null) {
            propErrorMap = new HashMap<String, Exception>();
            this._moRefToMissingProps.put(moRef, propErrorMap);
        }
        propErrorMap.put(propName, ex);
    }

    public void addPropertyValue(ManagedObjectReference moRef, String propName, Object value) {
        Validate.notNull((Object)moRef, (String)"moRef");
        Validate.notEmpty((String)propName, (String)"propName");
        Validate.isTrue((boolean)this._moRefs.contains(moRef), (String)(moRef + " is not part of the request."));
        Map<String, Object> propValueMap = this._moRefToProps.get(moRef);
        if (propValueMap == null) {
            propValueMap = new HashMap<String, Object>();
            this._moRefToProps.put(moRef, propValueMap);
        }
        propValueMap.put(propName, value);
    }

    @Override
    public Collection<ManagedObjectReference> getMoRefs() {
        return this._moRefs;
    }

    @Override
    public <T> T getProperty(ManagedObjectReference moRef, String propName) {
        Exception missingPropError;
        Validate.notNull((Object)moRef, (String)"moRef");
        Validate.notEmpty((String)propName, (String)"propName");
        Validate.isTrue((boolean)this._moRefs.contains(moRef), (String)(moRef + " is not part of the request."));
        Exception moRefError = this.getMoRefError(moRef);
        if (moRefError != null) {
            throw new PcResult.PcResultException(moRef, (Throwable)moRefError);
        }
        Map<String, Exception> missingPropMap = this._moRefToMissingProps.get(moRef);
        if (missingPropMap != null && (missingPropError = missingPropMap.get(propName)) != null) {
            throw new PcResult.PcResultException(moRef, propName, missingPropError);
        }
        Map<String, Object> objectProps = this._moRefToProps.get(moRef);
        if (objectProps == null) {
            throw new PcResult.PcResultException(moRef, propName, new PcResult.UnknownPropertyException(moRef, propName));
        }
        return (T)objectProps.get(propName);
    }

    @Override
    public Exception getErrorForGuid(String guid) {
        return this._guidToError.get(guid);
    }

    public void checkForNotFoundMoRefs() {
        for (ManagedObjectReference mor : this._moRefs) {
            if (this._moRefsInResult.contains(mor)) continue;
            LOGGER.warn("Adding MONF for [{}].", (Object)mor);
            this.addMoRefError(mor, (Exception)new ManagedObjectNotFound(mor));
        }
    }

    private Exception getMoRefError(ManagedObjectReference moRef) {
        Exception ex = this._guidToError.get(moRef.getServerGuid());
        return ex != null ? ex : this._moRefToError.get(moRef);
    }
}

