/*
 * Decompiled with CFR 0.152.
 */
package emitters.core;

import emitters.EmitterFactory;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.bindings.JavaServerEmitter;
import emitters.bindings.PythonStubEmitter;
import emitters.bindings.cpp.CppImplementationEmitter;
import emitters.bindings.cpp.CppInterfaceEmitter;
import emitters.bindings.cpp.CppPrivilegeEmitter;
import emitters.bindings.csharp.CsEmitter;
import emitters.bindings.csharp.CsPrivilegeEmitter;
import emitters.bindings.gobject.GObjectImplementationEmitter;
import emitters.bindings.gobject.GObjectInterfaceEmitter;
import emitters.bindings.gobject.GObjectPrivilegeEmitter;
import emitters.generators.LifecycleEmitter;
import emitters.generators.RecursiveDefsInfo;
import emitters.generators.VersionsEmitter;
import emitters.generators.info.ListMethods;
import emitters.generators.info.ListPrivileges;
import emitters.generators.joap.OpenAPI3;
import emitters.generators.joap.VMODL2;
import emitters.generators.vmodl.SourceEmitter;
import emitters.generators.xml.BeanTypesEmitter;
import emitters.generators.xml.EventExtensionEmitter;
import emitters.generators.xml.ListInternalApiEmitter;
import emitters.model.SyntheticVersion;
import emitters.wsdl.XMLTypeInfoEmitter;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Options {
    public final Collection<EmitterFactory> filteredList = new ArrayList<EmitterFactory>();
    public final Collection<EmitterFactory> filteredNonDynamicList = new ArrayList<EmitterFactory>();
    public final Collection<EmitterFactory> unfilteredList = new ArrayList<EmitterFactory>();
    public final Collection<EmitterFactory> unfilteredNonDynamicList = new ArrayList<EmitterFactory>();
    public String verTarget = null;
    public static String taskTypeName;
    public boolean wsdl2Requested;
    public boolean wsdlRequested;
    public boolean skipCoreObjects = true;
    public boolean checkForWsdlNameConflicts = false;
    public Map<String, String> xmlOptions = new HashMap<String, String>();
    public Map<String, String> wsdlOptions = new HashMap<String, String>();
    public Map<String, String> versionsOptions = new HashMap<String, String>();
    private Set<String> _emitSourceSet = new HashSet<String>();
    private Set<String> _noEmitSourceSet = new HashSet<String>();
    private Map<String, String> _cppOptions = new HashMap<String, String>();
    private Map<String, String> _cppPrivOptions = new HashMap<String, String>();
    private Map<String, String> _csOptions = new HashMap<String, String>();
    private Map<String, String> _dotOptions = new HashMap<String, String>();
    private Map<String, String> _eventOptions = new HashMap<String, String>();
    private Map<String, String> _cOptions = new HashMap<String, String>();
    private Map<String, String> _cPrivOptions = new HashMap<String, String>();
    private Map<String, String> _javaOptions = new HashMap<String, String>();
    private Map<String, String> _sourceOptions = new HashMap<String, String>();
    private Map<String, String> _openapi3Options = new HashMap<String, String>();
    private Map<String, String> _vmodl2Options = new HashMap<String, String>();
    private Map<String, String> _lifecycleOptions = new HashMap<String, String>();
    private Map<String, String> _infoMethodsOptions = new HashMap<String, String>();
    private Map<String, String> _infoPrivOptions = new HashMap<String, String>();
    private OptionProcessor[] _optionProcessors = new OptionProcessor[]{new EmitterRequest("hpp.dir"){

        @Override
        @BindingsEmitter
        @NonDynamicEmitter
        public VmodlEmitter newInstance() {
            return new CppInterfaceEmitter(Options.this._cppOptions, this._optionValue);
        }
    }, new EmitterRequest("cpp.dir"){

        @Override
        @BindingsEmitter
        @NonDynamicEmitter
        public VmodlEmitter newInstance() {
            return new CppImplementationEmitter(Options.this._cppOptions, this._optionValue);
        }
    }, new EmitterRequest("privhpp"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new CppPrivilegeEmitter(Options.this._cppPrivOptions, this._optionValue);
        }
    }, new EmitterRequest("cs"){

        @Override
        public VmodlEmitter newInstance() {
            return new CsEmitter(Options.this._csOptions, this._optionValue);
        }
    }, new EmitterRequest("cs.priv.consts"){

        @Override
        public VmodlEmitter newInstance() {
            return new CsPrivilegeEmitter(Options.this._csOptions, this._optionValue);
        }
    }, new EmitterRequest("events.base.event"){

        @Override
        public VmodlEmitter newInstance() {
            return new EventExtensionEmitter(Options.this._eventOptions, this._optionValue);
        }
    }, new EmitterRequest("py"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new PythonStubEmitter(this._optionValue, true);
        }
    }, new EmitterRequest("oss.py"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new PythonStubEmitter(this._optionValue, false);
        }
    }, new EmitterRequest("xti"){

        @Override
        public VmodlEmitter newInstance() {
            return new XMLTypeInfoEmitter(this._optionValue);
        }
    }, new EmitterRequest("header.dir"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new GObjectInterfaceEmitter(Options.this._cOptions, this._optionValue);
        }
    }, new EmitterRequest("c"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new GObjectImplementationEmitter(Options.this._cOptions, this._optionValue);
        }
    }, new EmitterRequest("privheader"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new GObjectPrivilegeEmitter(Options.this._cPrivOptions, this._optionValue);
        }
    }, new EmitterRequest("java.vmomi"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new JavaServerEmitter(Options.this._javaOptions, this._optionValue);
        }
    }, new EmitterRequest("versions"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new VersionsEmitter(Options.this.versionsOptions, this._optionValue);
        }
    }, new EmitterRequest("openapi3"){

        @Override
        @NonDynamicEmitter
        @SkipWsdlNameCheck
        public VmodlEmitter newInstance() {
            return new OpenAPI3(Options.this._openapi3Options, this._optionValue);
        }
    }, new EmitterRequest("vmodl2"){

        @Override
        @NonDynamicEmitter
        public VmodlEmitter newInstance() {
            return new VMODL2(Options.this._vmodl2Options, this._optionValue);
        }
    }, new EmitterRequest("source.folder"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new SourceEmitter(Options.this._sourceOptions, this._optionValue);
        }
    }, new EmitterRequest("bean.types"){

        @Override
        public VmodlEmitter newInstance() {
            return new BeanTypesEmitter(this._optionValue);
        }
    }, new EmitterRequest("list.api"){

        @Override
        public VmodlEmitter newInstance() {
            return new ListInternalApiEmitter(this._optionValue);
        }
    }, new EmitterRequest("lifecycle.folder"){

        @Override
        public VmodlEmitter newInstance() {
            return new LifecycleEmitter(Options.this._lifecycleOptions, this._optionValue);
        }
    }, new EmitterRequest("rdef.output"){

        @Override
        @BindingsEmitter
        public VmodlEmitter newInstance() {
            return new RecursiveDefsInfo(this._optionValue);
        }
    }, new EmitterRequest("info.methods"){

        @Override
        public VmodlEmitter newInstance() {
            return new ListMethods(Options.this._infoMethodsOptions, this._optionValue);
        }
    }, new EmitterRequest("info.priv"){

        @Override
        public VmodlEmitter newInstance() {
            return new ListPrivileges(Options.this._infoPrivOptions, this._optionValue);
        }
    }, new OptionGroup("ver.prefix.", Versions._onUnspecifiedVersion), new OptionGroup("package.", VmodlEmitter._packageMap), new OptionGroup("cpp.", this._cppOptions), new OptionGroup("privhpp.", this._cppPrivOptions), new OptionGroup("cs.", this._csOptions), new OptionGroup("dot.", this._dotOptions), new OptionGroup("c.", this._cOptions), new OptionGroup("privheader.", this._cPrivOptions), new OptionGroup("java.", this._javaOptions), new OptionGroup("xml.", this.xmlOptions), new OptionGroup("wsdl.", this.wsdlOptions), new OptionGroup("versions.", this.versionsOptions), new OptionGroup("events.", this._eventOptions), new OptionGroup("source.", this._sourceOptions), new OptionGroup("openapi3.", this._openapi3Options), new OptionGroup("vmodl2.", this._vmodl2Options), new OptionGroup("lifecycle.", this._lifecycleOptions), new OptionGroup("info.method.", this._infoMethodsOptions), new OptionGroup("info.priv.", this._infoPrivOptions), new OptionSet("ver.is.legacy", Versions._legacyVersionNames), new OptionSet("ver.is.default", Versions._legacyVersionNames)};
    private boolean _haveEmitFile = false;
    private boolean _haveEmitArg = false;

    public boolean shouldEmit(String source) {
        if (source == null || source.isEmpty()) {
            return false;
        }
        return !this._emitSourceSet.isEmpty() ? this._emitSourceSet.contains(source) : !this._noEmitSourceSet.contains(source);
    }

    protected Options() {
    }

    protected void processOption(String optionName, String optionValue) {
        if (this.parseWithProcessors(optionName, optionValue)) {
            if (optionName.startsWith("wsdl")) {
                this.wsdlRequested = true;
            }
            if (optionName.equals("wsdl.sharing")) {
                this.wsdl2Requested = true;
            }
        } else if (this.handleEmit(optionName, optionValue)) {
            this._haveEmitArg = true;
        } else if (optionName.equals("emit.defs.file")) {
            List<String> lines;
            Path path = Paths.get(optionValue, new String[0]);
            this._haveEmitFile = true;
            try {
                lines = Files.readAllLines(path, Charset.defaultCharset());
            }
            catch (Exception e) {
                throw new RuntimeException("Can't read args file '" + path + "': " + e.toString());
            }
            for (String line : lines) {
                String val;
                String[] pair = line.split("=");
                if (pair.length != 2) {
                    throw new RuntimeException("Illegal string format in emit arg file: " + line);
                }
                String opt = pair[0].substring(2);
                if (this.handleEmit(opt, val = pair[1])) continue;
                throw new RuntimeException("Illegal option in emit args file: " + opt);
            }
        } else if (optionName.equals("emit.dir")) {
            this._emitSourceSet = Utils.discoverEmitFiles(optionValue);
        } else if (optionName.equals("dir")) {
            this._emitSourceSet = Utils.resolve(this._emitSourceSet, optionValue);
            this._noEmitSourceSet = Utils.resolve(this._noEmitSourceSet, optionValue);
        } else if (optionName.equals("task.return.type")) {
            taskTypeName = optionValue;
        } else if (optionName.equals("ver.target")) {
            this.verTarget = optionValue;
        } else if (optionName.equals("two.operations.for.task.methods")) {
            Versions.setTwoOperationsForTaskMethod(Boolean.parseBoolean(optionValue));
        } else if (optionName.startsWith("xsd")) {
            this.wsdlOptions.put("xsd", optionValue);
            this.wsdlRequested = true;
        } else if (optionName.equals("vmodl.want.core.objects")) {
            this.skipCoreObjects = false;
        } else if (optionName.equals("xml")) {
            this.xmlOptions.put("", optionValue);
        } else if (optionName.equals("debug.digest")) {
            SyntheticVersion.sDebugDigest = Boolean.parseBoolean(optionValue);
        } else if (optionName.equals("allow.visibility.violations")) {
            Versions.allowVisibilityViolations();
        } else if (optionName.equals("disallow.visibility.violations")) {
            Versions.disallowVisibilityViolations();
        } else {
            throw new RuntimeException("Unsupported option -A" + optionName);
        }
    }

    private boolean handleEmit(String optionName, String optionValue) {
        if (optionName.equals("emit")) {
            this.handleEmit(this._emitSourceSet, optionValue);
        } else if (optionName.equals("noemit")) {
            this.handleEmit(this._noEmitSourceSet, optionValue);
        } else {
            return false;
        }
        return true;
    }

    private void handleEmit(Set<String> emitSet, String optionValue) {
        for (String value : optionValue.replace('/', File.separatorChar).split(",")) {
            emitSet.add(value);
        }
    }

    protected void finalizeParsing() {
        if (this._haveEmitArg && this._haveEmitFile) {
            throw new RuntimeException("Usage of both -A(no)emit and -Aemit.defs.file is forbidden");
        }
        if (!this._emitSourceSet.isEmpty() && !this._noEmitSourceSet.isEmpty()) {
            throw new RuntimeException("Cannot specify both -Aemit and -Anoemit");
        }
    }

    protected abstract void Parse(Map<String, String> var1);

    private void registerFactory(EmitterFactory factory) {
        boolean isNonDynamicEmitter;
        Method method = null;
        try {
            method = factory.getClass().getMethod("newInstance", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isBindingsEmitter = method.getAnnotation(BindingsEmitter.class) != null;
        boolean bl = isNonDynamicEmitter = method.getAnnotation(NonDynamicEmitter.class) != null;
        if (isBindingsEmitter) {
            if (isNonDynamicEmitter) {
                this.unfilteredNonDynamicList.add(factory);
            } else {
                this.unfilteredList.add(factory);
            }
        } else if (isNonDynamicEmitter) {
            this.filteredNonDynamicList.add(factory);
        } else {
            this.filteredList.add(factory);
        }
        if (method.getAnnotation(SkipWsdlNameCheck.class) == null) {
            this.checkForWsdlNameConflicts = true;
        }
    }

    private boolean parseWithProcessors(String optionName, String optionValue) {
        for (OptionProcessor optionProcessor : this._optionProcessors) {
            if (!optionProcessor.processOption(optionName, optionValue)) continue;
            return true;
        }
        return false;
    }

    private class OptionSet
    extends OptionProcessor {
        private final String _optionName;
        private final Set<String> _set;

        OptionSet(String optionName, Set<String> set) {
            this._optionName = optionName;
            this._set = set;
        }

        @Override
        boolean processOption(String optionName, String optionValue) {
            if (!optionName.equals(this._optionName)) {
                return false;
            }
            for (String value : optionValue.split(",")) {
                this._set.add(value);
            }
            return true;
        }
    }

    private class OptionGroup
    extends OptionProcessor {
        private final String _prefix;
        private final Map<String, String> _optionsList;

        OptionGroup(String prefix, Map<String, String> optionsList) {
            this._prefix = prefix;
            this._optionsList = optionsList;
        }

        @Override
        boolean processOption(String optionName, String optionValue) {
            if (!optionName.startsWith(this._prefix)) {
                return false;
            }
            String innerOption = optionName.substring(this._prefix.length());
            this._optionsList.put(innerOption, optionValue);
            return true;
        }
    }

    public abstract class EmitterRequest
    extends OptionProcessor
    implements EmitterFactory {
        protected String _optionName;
        protected String _optionValue;

        EmitterRequest(String optionName) {
            this._optionName = optionName;
        }

        @Override
        boolean processOption(String optionName, String optionValue) {
            if (!this._optionName.equals(optionName)) {
                return false;
            }
            this._optionValue = optionValue;
            Options.this.registerFactory(this);
            return true;
        }
    }

    private abstract class OptionProcessor {
        private OptionProcessor() {
        }

        abstract boolean processOption(String var1, String var2);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SkipWsdlNameCheck {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NonDynamicEmitter {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BindingsEmitter {
    }
}

