/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl;

import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.soap.XmlOutputHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlStreamWriterOutputHandler
implements XmlOutputHandler {
    private XMLStreamWriter _writer;

    public XmlStreamWriterOutputHandler(XMLStreamWriter writer) {
        this._writer = writer;
    }

    @Override
    public void writeStartDocument() throws MarshallException {
        try {
            this._writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new MarshallException("Unable to write XML declaration", e);
        }
    }

    @Override
    public void writeEndDocument() throws MarshallException {
        try {
            this._writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new MarshallException("Unable to end document", e);
        }
    }

    @Override
    public void writeStartElement(String localName) throws MarshallException {
        try {
            this._writer.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw new MarshallException(String.format("Unable to create element %1$s", localName), e);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws MarshallException {
        try {
            this._writer.writeStartElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new MarshallException(String.format("Unable to create element %1$s:%2$s", namespaceURI, localName), e);
        }
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws MarshallException {
        try {
            this._writer.writeStartElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new MarshallException(String.format("Unable to create element %1$s:%2$s", prefix, localName), e);
        }
    }

    @Override
    public void writeCharacters(String text) throws MarshallException {
        try {
            this._writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new MarshallException(String.format("Unable to append text element %1$s", text), e);
        }
    }

    @Override
    public void writeEndElement() throws MarshallException {
        try {
            this._writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new MarshallException("Unable to write end element", e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws MarshallException {
        try {
            this._writer.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            throw new MarshallException(String.format("Unable to write attribute %1$s", localName), e);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws MarshallException {
        try {
            this._writer.writeAttribute(prefix, namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw new MarshallException(String.format("Unable to write attribute %1$s:%2$s", prefix, localName), e);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws MarshallException {
        try {
            this._writer.writeNamespace(prefix, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new MarshallException(String.format("Unable to write prefix %1$s for namespace %2$s", prefix, namespaceURI), e);
        }
    }

    @Override
    public void flush() throws MarshallException {
        try {
            this._writer.flush();
        }
        catch (XMLStreamException e) {
            throw new MarshallException("Unable to flush writer", e);
        }
    }

    @Override
    public void close() throws MarshallException {
        try {
            this._writer.close();
        }
        catch (XMLStreamException e) {
            throw new MarshallException("Unable to close writer", e);
        }
    }
}

