/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.dr.ui.tools.utilities;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;

public class FolderIterator
implements Iterator<File> {
    private final Queue<File> _queue = new LinkedList<File>();
    private final Set<File> _traversed = new HashSet<File>();
    private final Filter _filter;
    private File _next = null;
    private final boolean _recursive;

    public FolderIterator(String path, Filter filter, boolean recursive) {
        if (path == null) {
            throw new IllegalArgumentException("path");
        }
        this._filter = filter;
        this._recursive = recursive;
        File root = new File(path);
        this.expandDirectory(root);
    }

    public FolderIterator(String path, boolean recursive) {
        this(path, null, recursive);
    }

    @Override
    public boolean hasNext() {
        while (this._next == null && !this._queue.isEmpty()) {
            File next = this._queue.poll();
            if (next.isDirectory() && this._recursive) {
                this.expandDirectory(next);
                continue;
            }
            if (!next.isFile() || !this.doFilter(next)) continue;
            this._next = next;
        }
        return this._next != null;
    }

    @Override
    public File next() {
        if (this._next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        File next = this._next;
        this._next = null;
        return next;
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    private boolean doFilter(File file) {
        return this._filter == null || this._filter.accept(file);
    }

    private void expandDirectory(File dir) {
        File[] files;
        if (dir == null || !dir.isDirectory()) {
            throw new IllegalArgumentException("dir");
        }
        if (this._traversed.add(dir) && (files = dir.listFiles()) != null) {
            this._queue.addAll(Arrays.asList(files));
        }
    }

    public static interface Filter {
        public boolean accept(File var1);
    }
}

