/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.Versions;
import emitters.model.Version;
import emitters.model.VmodlObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import vmodl.service;
import vmodl.supportsManagedObjectsOf;

public class Services {
    public static final String NONE_SERVICENAMESPACE = "";
    private static boolean initialized;
    private static service targetService;
    private static Map<String, Set<String>> importTypesMap;
    private static Map<String, String> namespaceMap;
    private static Map<String, List<Version>> includedVersionsMap;
    private static Set<String> includedOpSet;
    public static final service defaultService;

    public static void reset() {
        initialized = false;
        targetService = null;
        importTypesMap = new HashMap<String, Set<String>>();
        namespaceMap = new HashMap<String, String>();
        includedVersionsMap = new HashMap<String, List<Version>>();
        includedOpSet = new HashSet<String>();
    }

    public static void init() {
        Version targetVer = Versions.getTargetVersion();
        try {
            targetService = Services.getService(targetVer);
        }
        catch (Exception e) {
            return;
        }
        Services.buildImportSchemaMap(targetVer);
        for (String srv : importTypesMap.keySet()) {
            HashSet<String> results = new HashSet<String>();
            Services.mergeImportTypes(srv, results);
            importTypesMap.put(srv, results);
        }
        Services.buildIncludedOpSet(targetVer);
        includedOpSet.add(targetService.name());
        if (!importTypesMap.keySet().containsAll(includedOpSet)) {
            throw new RuntimeException("invalid service names : " + includedOpSet);
        }
        Services.buildIncludedVersionsMap();
        initialized = true;
    }

    private static void mergeImportTypes(String targetSrv, Set<String> results) {
        Set<String> srvs = importTypesMap.get(targetSrv);
        ArrayList<String> tmp = new ArrayList<String>(srvs);
        tmp.removeAll(results);
        results.addAll(tmp);
        for (String srv : tmp) {
            Services.mergeImportTypes(srv, results);
        }
    }

    public static void printSummary() {
        System.out.println("target service : " + Services.getTargetService());
        System.out.println("target name space : " + Services.schemaNamespaceId(Services.getTargetService()));
        System.out.println("import type map");
        for (String srv : importTypesMap.keySet()) {
            System.out.println("  Service : " + srv);
            for (String imp : importTypesMap.get(srv)) {
                System.out.println("     import : " + imp);
            }
        }
        System.out.println(NONE_SERVICENAMESPACE);
        System.out.println("namespaceMap");
        for (String srv : namespaceMap.keySet()) {
            System.out.println("  service = " + srv + " : ns = " + namespaceMap.get(srv));
        }
        System.out.println(NONE_SERVICENAMESPACE);
        System.out.println("includedVersionsMap :");
        for (String srv : includedVersionsMap.keySet()) {
            System.out.println("   service : " + srv);
            List<Version> vers = includedVersionsMap.get(srv);
            for (Version ver : vers) {
                System.out.println("     version : " + ver.getVmodlName());
            }
        }
        System.out.println(NONE_SERVICENAMESPACE);
        System.out.println("includedOpServiceSet :");
        for (String srv : includedOpSet) {
            System.out.println(" service  :" + srv);
        }
    }

    public static boolean shouldGenerateForSchema(String service2, Version version) {
        List<Version> vers = includedVersionsMap.get(service2);
        for (Version ver : vers) {
            if (version != ver) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldGenerateForOps(Version version) {
        for (String service2 : includedOpSet) {
            if (!Services.shouldGenerateForSchema(service2, version)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldGenerateForMessages(String service2) {
        return includedOpSet.contains(service2);
    }

    public static Map<String, Set<String>> getImportTypesMap() {
        return importTypesMap;
    }

    private static void buildIncludedVersionsMap() {
        for (String srv : importTypesMap.keySet()) {
            includedVersionsMap.put(srv, new ArrayList());
        }
        Version targetVer = Versions.getTargetVersion();
        for (Version ver : Versions.getVersions()) {
            service srv;
            List<Version> vers;
            if (!targetVer.isAncestor(ver) || (vers = includedVersionsMap.get((srv = Services.getService(ver)).name())) == null) continue;
            vers.add(ver);
        }
    }

    private static void buildIncludedOpSet(Version targetVer) {
        String[] services;
        supportsManagedObjectsOf moTypes = targetVer.getSupportedMO();
        Version version = targetVer;
        String serivceName = Services.getService(version).name();
        while (moTypes == null) {
            if ((version = Services.findParentVersion(serivceName, version)) == null) {
                return;
            }
            moTypes = version.getSupportedMO();
        }
        for (String serviceName : services = moTypes.value()) {
            includedOpSet.add(serviceName);
            Version ver = Services.findParentVersion(serviceName, version);
            if (ver == null) {
                throw new RuntimeException("No version found for service : " + serviceName);
            }
            Services.buildIncludedOpSet(ver);
        }
    }

    private static Version findParentVersion(String serviceName, Version start) {
        Version parent = null;
        Set<Version> parents = start.getDirectParents();
        if (parents != null) {
            for (Version ver : parents) {
                if (!serviceName.equals(Services.getService(ver).name())) continue;
                parent = ver;
                break;
            }
            if (parent == null) {
                service srv = Services.getService(start);
                for (Version ver : parents) {
                    if (srv != Services.getService(ver)) continue;
                    parent = Services.findParentVersion(serviceName, ver);
                    break;
                }
            }
        }
        return parent;
    }

    private static void buildImportSchemaMap(Version version) {
        service srv = Services.getService(version);
        String srvName = srv.name();
        if (!importTypesMap.containsKey(srvName)) {
            importTypesMap.put(srvName, new HashSet());
            namespaceMap.put(srvName, srv.namespace());
        }
        Set<String> imports = importTypesMap.get(srvName);
        Set<Version> parents = version.getDirectParents();
        if (parents != null) {
            ArrayList<Version> tmp = new ArrayList<Version>(parents);
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                Version ver = (Version)it.next();
                service importService = Services.getService(ver);
                String name = importService.name();
                if (name.equals(srvName)) continue;
                imports.add(importService.name());
                Services.buildImportSchemaMap(ver);
                it.remove();
            }
            for (Version ver : tmp) {
                Services.buildImportSchemaMap(ver);
            }
        }
    }

    public static String schemaNamespaceId(Version version) {
        if (!initialized) {
            return NONE_SERVICENAMESPACE;
        }
        service srv = Services.getService(version);
        return Services.schemaNamespaceId(srv.name());
    }

    public static String effectiveNamespaceId(Version version) {
        String versionNS = version.getWireNs();
        if (!versionNS.isEmpty()) {
            return versionNS;
        }
        return Services.schemaNamespaceId(version);
    }

    public static String schemaNamespaceId(String serviceName) {
        if (!initialized) {
            return NONE_SERVICENAMESPACE;
        }
        return namespaceMap.get(serviceName);
    }

    public static service getService(Version version) {
        return version.getService();
    }

    public static String getTargetService() {
        if (!initialized) {
            return null;
        }
        return targetService.name();
    }

    public static boolean isObjectFromTargetService(VmodlObject object) {
        return Services.isPackageFromTargetService(object.getVersion());
    }

    public static boolean isPackageFromTargetService(Version version) {
        service objectService = Services.getService(version);
        if (!initialized) {
            return objectService == null;
        }
        return Services.getTargetService().equals(objectService.name());
    }

    static {
        defaultService = new service(){

            public Class<? extends Annotation> annotationType() {
                return this.getClass();
            }

            public String name() {
                return Services.NONE_SERVICENAMESPACE;
            }

            public String namespace() {
                return Services.NONE_SERVICENAMESPACE;
            }
        };
    }
}

