/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.csharp;

import emitters.model.Property;
import emitters.model.VmodlObject;

public class Common {
    public static String firstWord(String s, String wordDelim) {
        int index = s.indexOf(wordDelim);
        if (index != -1) {
            return s.substring(0, index);
        }
        return s;
    }

    public static String removeFirstWord(String s, String wordDelim, StringBuffer word) {
        word.setLength(0);
        int index = s.indexOf(wordDelim);
        if (index == -1) {
            word.append(s);
            return "";
        }
        word.append(s.substring(0, index));
        return s.substring(index + 1);
    }

    public static String lastWord(String s, String wordDelim) {
        int index = s.lastIndexOf(wordDelim);
        if (index == -1) {
            return s;
        }
        return s.substring(index + 1);
    }

    public static String lastWord(String s, String[] wordDelims) {
        int index = -1;
        for (String wordDelim : wordDelims) {
            index = Math.max(index, s.lastIndexOf(wordDelim));
        }
        if (index == -1) {
            return s;
        }
        return s.substring(index + 1);
    }

    public static String removeLastWord(String s, String wordDelim) {
        int index = s.lastIndexOf(wordDelim);
        if (index == -1) {
            return "";
        }
        return s.substring(0, index);
    }

    public static String relativePath(String relativeTo, String path, String wordDelim) {
        String relativeRoot;
        if (relativeTo.length() > 0 && path.startsWith(relativeRoot = relativeTo + wordDelim)) {
            return path.substring(relativeRoot.length());
        }
        return path;
    }

    public static Property propertyByName(VmodlObject obj, String propName) {
        for (Property prop : obj.getPropertyList()) {
            if (!prop.getName().equals(propName)) continue;
            return prop;
        }
        if (obj.getBaseObject() != null) {
            return Common.propertyByName(obj.getBaseObject(), propName);
        }
        return null;
    }

    public static VmodlObject nestedTypeByName(VmodlObject obj, String name) {
        if (obj == null) {
            return null;
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            if (!nestedObj.getClassName().equals(name)) continue;
            return nestedObj;
        }
        return Common.nestedTypeByName(obj.getBaseObject(), name);
    }

    public static boolean containsNestedTypeOfName(VmodlObject obj, String name) {
        return Common.nestedTypeByName(obj, name) != null;
    }

    public static VmodlObject conflictingContainerNestedType(VmodlObject obj) {
        VmodlObject container = obj.getContainer();
        VmodlObject containerBase = container == null ? null : container.getBaseObject();
        return Common.nestedTypeByName(containerBase, obj.getClassName());
    }
}

