/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.init.workflow;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.OperationWaiter;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.authentication.websso.WebSsoAuthenticationStrategy;
import com.vmware.srm.client.infrastructure.init.workflow.DrInitException;
import com.vmware.srm.client.infrastructure.init.workflow.Status;
import com.vmware.srm.client.infrastructure.oauth2.OAuth2Context;
import com.vmware.srm.client.infrastructure.websso.SsoContext;
import com.vmware.srm.client.topology.impl.common.AsyncOpRetryWrapper;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.init.SecurityPolicyConfig;
import com.vmware.srm.client.topology.impl.sso.SolutionUserConfig;
import com.vmware.srm.client.topology.impl.sso.StartupKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configurator.class);
    private final AsyncOpRetryWrapper<SsoContext> _webSsoAsyncRetry = new AsyncOpRetryWrapper(SsoContext::create);
    private final AsyncOpRetryWrapper<OAuth2Context> _oauth2AsyncRetry = new AsyncOpRetryWrapper(OAuth2Context::create);

    public void start() {
        try {
            this._webSsoAsyncRetry.get().onError(exc -> LOGGER.warn("Failed to create websso context:", (Throwable)exc));
        }
        catch (Exception e) {
            LOGGER.error("Failed to start creating websso context ", (Throwable)e);
        }
        if (Config.get().getVidmEnabled()) {
            try {
                this._oauth2AsyncRetry.get().onError(exc -> LOGGER.warn("Failed to create oauth2 context:", (Throwable)exc));
            }
            catch (Exception e) {
                LOGGER.error("Failed to start creating oauth2 context ", (Throwable)e);
            }
        }
    }

    public Promise<SsoContext> getSsoContext() {
        return Promises.from(() -> {
            this.checkForExc(Config.get().ensureLoaded(), Status.CONFIG_ERROR);
            this.checkForExc(SecurityPolicyConfig.get().ensureLoaded(), Status.CONFIG_ERROR);
            this.checkForExc(StartupKeyStore.get().ensureLoaded(), Status.KEY_STORE_ERROR);
            this.checkForExc(SolutionUserConfig.get().ensureLoaded(), Status.SU_CERT_PAIR_ERROR);
            return null;
        }).thenCompose(unused -> this._webSsoAsyncRetry.get());
    }

    public Promise<AuthenticationStrategy> getWebSsoStrategy() throws DrInitException {
        return this.getSsoContext().thenApply(WebSsoAuthenticationStrategy::new);
    }

    public Promise<AuthenticationStrategy> getOAuth2Strategy() throws DrInitException {
        if (!Config.get().getVidmEnabled()) {
            return Promises.resolve(null);
        }
        return this.getSsoContext().thenCombine(this._oauth2AsyncRetry.get(), (sso, oauth2) -> new OAuth2AuthenticationStrategy((OAuth2Context)oauth2, (SsoContext)sso));
    }

    private void checkForExc(OperationWaiter<?> ow, Status status) {
        Exception exc = ow.getError();
        if (exc == null) {
            return;
        }
        throw status.create(exc);
    }
}

