/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.vmomi.client.common.Exchange;
import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.client.exception.ClientHaltException;
import com.vmware.vim.vmomi.client.exception.InvalidSslCertificateException;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ApacheClientRequestConfigurationMerger;
import com.vmware.vim.vmomi.client.http.impl.ApacheClientTracingAdapter;
import com.vmware.vim.vmomi.client.http.impl.HttpSchemeUtils;
import com.vmware.vim.vmomi.client.http.impl.TracingScopedRunnable;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.tracing.GlobalTracer;
import com.vmware.vim.vmomi.core.tracing.TracingFeature;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.EntityUtils;

public abstract class HttpExchangeBase
extends TracingScopedRunnable
implements Exchange,
Runnable {
    private static final Log LOG = LogFactory.getLog(HttpExchangeBase.class);
    private static final String WORKFLOW_SPAN_TAG = "workflow";
    private static final String OPID_SPAN_TAG = "opId";
    protected static final Header CONTENT_TYPE = new BasicHeader("Content-Type", "text/xml; charset=utf-8");
    protected static final Header ACCEPT_ENCODING = new BasicHeader("Accept-Encoding", "gzip");
    protected static final Header CONTENT_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    protected static final String REQUEST_VERSION_ID_TEMPLATE = "urn:%1$s/%2$s";
    private final Request _request;
    private final Response _response;
    private final CompiledHttpConfiguration _compiledConfig;
    private final URI _endpoint;
    private final boolean _enableCompression;
    private final InvocationInterceptor _invocationInterceptor;
    private final ApacheClientRequestConfigurationMerger _configMerger;
    private final Object _tracingSpan;

    protected HttpExchangeBase(Request request, Response response, CompiledHttpConfiguration compiledHttpConfig, ApacheClientRequestConfigurationMerger configMerger, URI endpoint, boolean enableCompression, InvocationInterceptor invocationInterceptor, String io, boolean sync) {
        this._request = request;
        this._response = response;
        this._compiledConfig = compiledHttpConfig;
        this._configMerger = configMerger;
        this._endpoint = endpoint;
        this._enableCompression = enableCompression;
        this._invocationInterceptor = invocationInterceptor;
        this._tracingSpan = TracingFeature.ON ? this.startTrace(io, sync) : null;
    }

    @Override
    public Request getRequest() {
        return this._request;
    }

    @Override
    public Response getResponse() {
        return this._response;
    }

    protected void beginInvocation() {
        block5: {
            if (this._invocationInterceptor != null) {
                try {
                    this._invocationInterceptor.beginInvocation(this.getInvocationContext());
                }
                catch (Exception e) {
                    if (e instanceof ClientHaltException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"ClientHaltException on InvocationInterceptor.beginInvocation(...), aborting execution", (Throwable)e);
                        }
                        throw (ClientHaltException)e;
                    }
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)"Exception on InvocationInterceptor.beginInvocation(...)", (Throwable)e);
                }
            }
        }
    }

    protected void completeInvocation(boolean success) {
        block4: {
            if (this._invocationInterceptor != null) {
                try {
                    this._invocationInterceptor.completeInvocation(this.getInvocationContext(), success);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)"Exception on InvocationInterceptor.completeInvocation(...)", (Throwable)e);
                }
            }
        }
        if (TracingFeature.ON) {
            this.finishTrace();
        }
    }

    private Object startTrace(String io, boolean sync) {
        Object opId;
        RequestContext context;
        String workflowVal;
        ManagedMethod method = this.getInvocationContext().getMethod();
        Tracer tracer = GlobalTracer.get();
        String spanName = method.getFullyQualifiedVmodlName() == null ? method.getName() : method.getFullyQualifiedVmodlName();
        Span span = tracer.buildSpan(spanName).withTag(Tags.COMPONENT.getKey(), "vlsi-client").withTag(Tags.SPAN_KIND.getKey(), "client").withTag("thread", Thread.currentThread().getName()).withTag(Tags.HTTP_METHOD.getKey(), "POST").withTag(Tags.HTTP_URL.getKey(), this._endpoint.toString()).withTag("io", io).withTag("sync", sync).start();
        String workflowCurrentVal = span.getBaggageItem(WORKFLOW_SPAN_TAG);
        String string = workflowVal = workflowCurrentVal == null ? method.getFullyQualifiedVmodlName() : workflowCurrentVal;
        if (workflowVal != null) {
            span.setBaggageItem(WORKFLOW_SPAN_TAG, workflowVal);
            span.setTag(WORKFLOW_SPAN_TAG, workflowVal);
        }
        if ((context = this.getInvocationContext().getStubRequestContext()) != null && (opId = context.get((Object)"operationID")) != null) {
            span.setTag(OPID_SPAN_TAG, opId.toString());
        }
        return span;
    }

    protected void finishTrace() {
        InetSocketAddress remoteAddress;
        Span span = (Span)this._tracingSpan;
        InvocationContext ic = this.getInvocationContext();
        InetSocketAddress localAddress = ic.getLocalAddress();
        if (localAddress != null) {
            span.setTag("local.hostname", localAddress.getHostString()).setTag("local.port", (Number)localAddress.getPort());
        }
        if ((remoteAddress = ic.getRemoteAddress()) != null) {
            span.setTag(Tags.PEER_HOSTNAME.getKey(), remoteAddress.getHostString()).setTag(Tags.PEER_PORT.getKey(), (Number)remoteAddress.getPort());
        }
        span.finish();
    }

    protected HttpPost prepareRequest() throws IOException, MarshallException {
        String versionId;
        HttpPost post = new HttpPost(this._endpoint);
        post.setHeader(CONTENT_TYPE);
        if (this._enableCompression) {
            post.setHeader(CONTENT_ENCODING);
            post.setHeader(ACCEPT_ENCODING);
        }
        post.setHeader("SOAPAction", (versionId = this._request.getVersion().getVersionId()) != null && versionId.length() > 0 ? String.format(REQUEST_VERSION_ID_TEMPLATE, this._request.getVersion().getNamespace(), versionId) : "");
        post.setEntity((HttpEntity)new RequestEntity());
        if (TracingFeature.ON) {
            this.putTracingInHttpHeaders(post);
        }
        return post;
    }

    private void putTracingInHttpHeaders(HttpPost post) {
        Span span = (Span)this._tracingSpan;
        GlobalTracer.get().inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new ApacheClientTracingAdapter((HttpMessage)post));
    }

    protected URI getEndPoint() {
        return this._endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseResponse(HttpResponse response) throws IOException {
        InputStream responseBody = null;
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (TracingFeature.ON) {
                this.setStatusCodeInTrace(statusCode);
            }
            if (statusCode == Response.Status.InvalidSslCertificate.getCode()) {
                throw new InvalidSslCertificateException("Invalid SSL certificate (HTTP 526 status code)", EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
            }
            responseBody = response.getEntity().getContent();
            Header contentEncoding = response.getFirstHeader("Content-Encoding");
            if (contentEncoding != null && "gzip".equals(contentEncoding.getValue())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Received HTTP response with gzip content encoding.");
                }
                responseBody = new GZIPInputStream(responseBody);
            }
            this.getResponse().setResponse(Response.Status.getStatus(statusCode), responseBody);
        }
        finally {
            block13: {
                if (responseBody != null) {
                    try {
                        responseBody.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block13;
                        LOG.debug((Object)"Exception on connection close.", (Throwable)e);
                    }
                }
            }
        }
    }

    private void setStatusCodeInTrace(int statusCode) {
        ((Span)this._tracingSpan).setTag(Tags.HTTP_STATUS.getKey(), (Number)statusCode);
    }

    protected HttpClientContext prepareLocalContext() {
        RequestConfig config = this._configMerger.mergeWithDefaultConfig(this._request.getConfiguration());
        HttpClientContext httpContext = new HttpClientContext();
        httpContext.setRequestConfig(config);
        if (!HttpSchemeUtils.isSecure(this.getEndPoint())) {
            return httpContext;
        }
        if (this._compiledConfig.getClientSSLToken() != null) {
            httpContext.setUserToken((Object)this._compiledConfig.getClientSSLToken());
        }
        return httpContext;
    }

    protected InvocationContext getInvocationContext() {
        return ((ResponseImpl)this._response).getInvocationContext();
    }

    protected void extractUserToken(HttpClientContext httpContext) {
        if (httpContext == null || !HttpSchemeUtils.isSecure(this.getEndPoint())) {
            return;
        }
        if (httpContext.getUserToken() != null && this._compiledConfig.getClientSSLToken() == null) {
            this._compiledConfig.setClientSSLToken((Principal)httpContext.getUserToken(Principal.class));
        }
    }

    void extractInetAddresses(HttpContext httpContext) {
        InetSocketAddress localAddress = null;
        InetSocketAddress remoteAddress = null;
        try {
            HttpInetConnection connection = (HttpInetConnection)((HttpCoreContext)httpContext).getConnection(HttpInetConnection.class);
            localAddress = new InetSocketAddress(connection.getLocalAddress(), connection.getLocalPort());
            remoteAddress = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
        }
        catch (Exception e) {
            LOG.trace((Object)"Unable to extract IP addresses from http-client", (Throwable)e);
        }
        try {
            this.getInvocationContext().setInetAddresses(localAddress, remoteAddress);
        }
        catch (Exception e) {
            LOG.debug((Object)String.format("Unable to set local (%s) and remote (%s) IP addresses in invocation-context", localAddress, remoteAddress), (Throwable)e);
        }
    }

    protected void setResponseError(Exception e) {
        if (TracingFeature.ON) {
            this.setErrorInTrace(e);
        }
        this.getResponse().setError(e);
    }

    private void setErrorInTrace(Exception e) {
        fullyQualifiedVmodlName fullyQualifiedVmodlErrorName;
        Throwable cause = e.getCause();
        if (cause != null && (fullyQualifiedVmodlErrorName = cause.getClass().getAnnotation(fullyQualifiedVmodlName.class)) != null) {
            ((Span)this._tracingSpan).setTag("error.type", fullyQualifiedVmodlErrorName.value());
        }
        Map<String, Exception> errorLogs = Collections.singletonMap("error.what", e);
        ((Span)this._tracingSpan).log(errorLogs).setTag(Tags.ERROR.getKey(), true);
    }

    @Override
    protected Object getTracingSpan() {
        return this._tracingSpan;
    }

    private class RequestEntity
    extends AbstractHttpEntity {
        private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

        public RequestEntity() throws IOException, MarshallException {
            OutputStream os = HttpExchangeBase.this._enableCompression ? new GZIPOutputStream(this._buffer) : this._buffer;
            HttpExchangeBase.this._request.writeBody(os);
            os.close();
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return this._buffer.size();
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this._buffer.toByteArray());
        }

        public void writeTo(OutputStream outstream) throws IOException {
            outstream.write(this._buffer.toByteArray());
        }

        public boolean isStreaming() {
            return false;
        }
    }
}

