/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.Session;
import com.vmware.vim.vmomi.client.exception.ClientException;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpProtocolBinding;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.client.http.impl.HttpSession;
import com.vmware.vim.vmomi.client.http.impl.VlsiCookieSpecProvider;
import java.net.URI;
import java.util.Date;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;

public abstract class HttpProtocolBindingBase
implements HttpProtocolBinding {
    private static final Log LOG = LogFactory.getLog(HttpProtocolBindingBase.class);
    private static final Date EXPIRED = new Date(0L);
    private final Executor _executor;
    private final URI _endpointUri;
    private final ServerEndpointProvider _endpointProvider;
    private final HttpConfiguration _config;
    private HttpConfiguration.CompressionSupport _serverCompressionSupport;
    private InvocationInterceptor _invocationInterceptor;
    protected CookieStore _cookieStore;

    abstract HttpResponse executeRequest(HttpUriRequest var1);

    HttpProtocolBindingBase(URI serverUri, Executor executor, ServerEndpointProvider endpointProvider, HttpConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("Client HTTP configuration is required");
        }
        this._endpointProvider = endpointProvider;
        this._endpointUri = serverUri;
        this._executor = executor;
        this._config = config;
        this._cookieStore = new BasicCookieStore();
    }

    @Override
    public HttpConfigurationImpl getConfiguration() {
        return (HttpConfigurationImpl)this._config;
    }

    @Override
    public Executor getExecutor() {
        return this._executor;
    }

    @Override
    public HttpConfiguration.CompressionSupport getServerCompressionSupport() {
        return this._serverCompressionSupport;
    }

    @Override
    public URI getEndpointUri() {
        if (this._endpointUri != null) {
            return this._endpointUri;
        }
        URI endpoint = null;
        try {
            endpoint = this._endpointProvider.getServerEndpoint();
        }
        catch (RuntimeException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Exception in ServerEndpointProvider.getServerEndpoint(...)", (Throwable)e);
            }
            throw new ClientException("Unable to get server endpont address", e);
        }
        if (endpoint == null) {
            throw new ClientException("Unable to get server endpont address, ServerEndpointProvider returned null");
        }
        return endpoint;
    }

    HttpConfiguration.CompressionSupport getCompressionSupport() {
        return this._serverCompressionSupport;
    }

    void setCompressionSupport(HttpConfiguration.CompressionSupport compressionSupport) {
        this._serverCompressionSupport = compressionSupport;
    }

    public void setInvocationInterceptor(InvocationInterceptor invocationInterceptor) {
        this._invocationInterceptor = invocationInterceptor;
    }

    InvocationInterceptor getInvocationInterceptor() {
        return this._invocationInterceptor;
    }

    @Override
    public void setSession(Session session) {
        HttpSession httpSession = (HttpSession)session;
        this.setCookie("vmware_soap_session", httpSession.getId(), httpSession.getPath(), httpSession.getDomain());
    }

    @Override
    public void clearSession() {
        Cookie cookie;
        while ((cookie = this.getFirstCookie("vmware_soap_session")) != null) {
            this.removeCookie(cookie);
        }
    }

    @Override
    public Session getSession() {
        Cookie cookie = this.getFirstCookie("vmware_soap_session");
        if (cookie == null) {
            return null;
        }
        return new HttpSession(cookie.getValue(), cookie.getPath(), cookie.getDomain());
    }

    @Override
    public Session createSession(String id) {
        return new HttpSession(id, "/", this.getEndpointUri().getHost());
    }

    CookieStore getCookieStore() {
        return this._cookieStore;
    }

    private void setCookie(String name, String value, String path, String domain) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(domain);
        this.getCookieStore().addCookie((Cookie)cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cookie getFirstCookie(String name) {
        CookieStore cookieStore;
        CookieStore cookieStore2 = cookieStore = this.getCookieStore();
        synchronized (cookieStore2) {
            for (Cookie cookie : cookieStore.getCookies()) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    private void removeCookie(Cookie cookie) {
        BasicClientCookie remove = new BasicClientCookie(cookie.getName(), cookie.getValue());
        remove.setPath(cookie.getPath());
        remove.setDomain(cookie.getDomain());
        remove.setExpiryDate(EXPIRED);
        this.getCookieStore().addCookie((Cookie)remove);
    }

    protected void executeRunnable(Runnable runnable, boolean sync) {
        if (this.getExecutor() != null && !sync) {
            this.getExecutor().execute(runnable);
        } else {
            if (!sync && LOG.isWarnEnabled()) {
                LOG.warn((Object)"Asynchronous execution requested but no Executor configured. The request will be executed as synchronous one.");
            }
            runnable.run();
        }
    }

    protected HttpConfiguration.CompressionSupport resolveServerCompressionSupport() {
        HttpConfiguration.CompressionSupport res = this.getConfiguration().getCompressionSupport();
        if (this.getConfiguration().getCompressionSupport() == HttpConfiguration.CompressionSupport.ASK_SERVER) {
            HttpOptions options = new HttpOptions(this.getEndpointUri());
            HttpResponse optionsResponse = this.executeRequest((HttpUriRequest)options);
            Header acceptEncodingHeader = optionsResponse.getFirstHeader("Accept-Encoding");
            if (acceptEncodingHeader != null && acceptEncodingHeader.getValue().contains("gzip")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Server supports compression.");
                }
                res = HttpConfiguration.CompressionSupport.ENABLE;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Server does not support compression.");
                }
                res = HttpConfiguration.CompressionSupport.DISABLE;
            }
        }
        return res;
    }

    protected static Lookup<CookieSpecProvider> createCookieSpecProviderRegistry() {
        return RegistryBuilder.create().register("standard", (Object)new VlsiCookieSpecProvider()).build();
    }
}

