/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vim.vmomi.core.types.VmodlArrayType;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.lang.reflect.Array;

public class VmodlArrayTypeImpl
implements VmodlArrayType {
    private final VmodlType _componentType;
    private Class _arrayClass;
    private Class _itemType;
    private String _wsdlName;
    private TypeName _typeName;
    private static final String _arrayWsdlnamePrefix = "ArrayOf";

    public VmodlArrayTypeImpl(VmodlType componentType, VmodlContext context) {
        this.checkParameters(componentType);
        this._componentType = componentType;
        this._arrayClass = Array.newInstance(componentType.getTypeClass(), 0).getClass();
        this._itemType = this._componentType.getTypeClass();
        this._wsdlName = _arrayWsdlnamePrefix + Character.toUpperCase(this._componentType.getWsdlName().charAt(0)) + this._componentType.getWsdlName().substring(1);
        this._typeName = new TypeNameImpl(this);
    }

    public VmodlArrayTypeImpl(VmodlType componentType, Class itemTypeOverride, VmodlContext context) {
        this.checkParameters(componentType);
        this._componentType = componentType;
        this._arrayClass = Array.newInstance(itemTypeOverride, 0).getClass();
        this._itemType = itemTypeOverride;
        this._wsdlName = _arrayWsdlnamePrefix + Character.toUpperCase(this._componentType.getWsdlName().charAt(0)) + this._componentType.getWsdlName().substring(1);
        this._typeName = new TypeNameImpl(this);
    }

    private void checkParameters(VmodlType componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("The array component type is required.");
        }
    }

    @Override
    public String getWsdlName() {
        return this._wsdlName;
    }

    @Override
    public TypeName getTypeName() {
        return this._typeName;
    }

    @Override
    public VmodlVersion getVersion() {
        return this._componentType.getVersion();
    }

    @Override
    public VmodlType.Kind getKind() {
        return VmodlType.Kind.ARRAY;
    }

    @Override
    public boolean IsVisible(VmodlVersion version) {
        return version.isCompatible(this._componentType.getVersion());
    }

    public Class getTypeClass() {
        return this._arrayClass;
    }

    @Override
    public VmodlType getComponentType() {
        return this._componentType;
    }

    public void setItemType(Class itemType) {
        this._itemType = itemType;
    }

    @Override
    public Object newInstance(int dimension) {
        return Array.newInstance(this._itemType, dimension);
    }

    @Override
    public VmodlContext getVmodlContext() {
        return this._componentType.getVmodlContext();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VmodlArrayTypeImpl)) {
            return false;
        }
        return this._itemType == ((VmodlArrayTypeImpl)obj)._itemType;
    }

    public int hashCode() {
        return this._itemType == null ? 0 : this._itemType.hashCode();
    }
}

