/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Pair;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.srm.client.topology.impl.core.builder.ViewBuilder;
import com.vmware.srm.client.topology.impl.core.operations.faults.ProviderNotAuthenticatedException;
import com.vmware.srm.client.topology.impl.sso.SolutionUserConfig;
import com.vmware.srm.client.topology.impl.sso.SsoUtils;
import com.vmware.srm.client.topology.impl.utils.Exceptions;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyImpl
implements Topology {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyImpl.class);
    private static final long REFRESH_DELAY = 300L;
    private static final ScheduledExecutorService SCHEDULED_EXEC = Utils.getScheduledExecutor();
    private final ViewBuilder _viewBuilder;
    private final AtomicBoolean _disposed = new AtomicBoolean(false);
    private final Object _viewLock = new Object();
    private volatile ServersView _currentView = null;
    private final AtomicReference<Future<?>> _nextTimerTask = new AtomicReference<Object>(null);
    private final ThreadContext _context;
    private final AtomicReference<Pair<String, String>> _serverGuidByRequestId = new AtomicReference<Object>(null);

    public TopologyImpl(URI lsppUrl, String lsppThumbprint) {
        this(lsppUrl, lsppThumbprint, SsoUtils.CERT, SsoUtils.KEY_PAIR.getPrivate());
    }

    public TopologyImpl(URI lsppUrl, String lsppThumbprint, SolutionUserConfig suConfig) {
        this(lsppUrl, lsppThumbprint, suConfig.getCert(), suConfig.getKey());
    }

    public TopologyImpl(URI lsppUrl, String lsppThumbprint, X509Certificate stsClientCertificate, PrivateKey stsClientPrivateKey) {
        this._context = ThreadContext.get();
        this._viewBuilder = new ViewBuilder(lsppUrl, lsppThumbprint, stsClientCertificate, stsClientPrivateKey);
    }

    public <T extends ServersView> Promise<T> init(String username, String password) {
        return this.executeInOwnContext(() -> this.authenticate(username, password).onSuccess(unused -> this.scheduleNextRefreshTask()));
    }

    public <T extends ServersView> Promise<T> init(SamlToken suToken, SamlToken actAsToken) {
        return this.executeInOwnContext(() -> this.authenticate(suToken, actAsToken).onSuccess(unused -> this.scheduleNextRefreshTask()));
    }

    public <T extends ServersView> Promise<T> initWithSolutionUser() {
        return this.executeInOwnContext(() -> this.authenticateWithSolutionUser().onSuccess(unused -> this.scheduleNextRefreshTask()));
    }

    @Override
    public <T extends ServersView> T getView() {
        return (T)this._currentView;
    }

    @Override
    public <T extends ServersView> T refresh() {
        return (T)this.executeInOwnContext(this::doRefresh);
    }

    @Override
    public <T extends ServersView> Promise<T> authenticate(String username, String password) {
        return this.executeInOwnContext(() -> this.authenticate(() -> this._viewBuilder.startBuildView(username, password)));
    }

    @Override
    public <T extends ServersView> Promise<T> authenticate(SamlToken suToken, SamlToken actAsToken) {
        if (suToken == null) {
            return Promises.reject((Exception)new IllegalStateException("suToken"));
        }
        return this.executeInOwnContext(() -> this.authenticate(() -> this._viewBuilder.startBuildView(suToken, actAsToken)));
    }

    @Override
    public <T extends ServersView> Promise<T> authenticateWithSolutionUser() {
        return this.executeInOwnContext(() -> this.authenticate(this._viewBuilder::startBuildViewWithSolutionUser));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ServersView> Promise<T> authenticate(Supplier<Promise<ServersView>> viewSupplier) {
        ServersView current;
        Promise<ServersView> result;
        Object object = this._viewLock;
        synchronized (object) {
            result = viewSupplier.get();
            current = this._currentView;
        }
        return result.thenApply(newView -> {
            Object object = this._viewLock;
            synchronized (object) {
                if (this._currentView == current) {
                    this._currentView = newView;
                }
                return newView;
            }
        });
    }

    @Override
    public boolean isAuthenticated() {
        return this.executeInOwnContext(this._viewBuilder::isAuthenticated);
    }

    @Override
    public <T extends ServersView> Promise<T> loginPair(PairSetup<?> pairSetup, String username, String password) {
        return this.doLoginPair(pairSetup, provider -> provider.loginWith(username, password));
    }

    @Override
    public <T extends ServersView> Promise<T> loginPair(PairSetup<?> pairSetup, X509Certificate certificate, PrivateKey key) {
        return this.doLoginPair(pairSetup, provider -> provider.loginWith(certificate, key));
    }

    @Override
    public String getRemoteLoginServer(String requestId) {
        Pair<String, String> pair = this._serverGuidByRequestId.get();
        if (pair == null || !((String)pair.first()).equals(requestId)) {
            return null;
        }
        return (String)pair.second();
    }

    @Override
    public void setRemoteLoginServer(String requestId, PairSetup<?> pairSetup) {
        Objects.requireNonNull(requestId, "requestId");
        Objects.requireNonNull(pairSetup, "pairSetup");
        Pair<String, String> current = this._serverGuidByRequestId.getAndSet((Pair<String, String>)new Pair((Object)requestId, (Object)pairSetup.pairServerGuid()));
        if (current != null) {
            LOGGER.warn("Overwriting existing remote login request for server {}", current.second());
        }
    }

    @Override
    public <T extends ServersView> Promise<T> loginPair(String requestId, PairSetup<?> pairSetup, SamlToken bearerToken, TokenProvider.RefreshData loginData) {
        Pair<String, String> pair = this._serverGuidByRequestId.get();
        if (pair == null || !((String)pair.first()).equals(requestId)) {
            return Promises.reject((Exception)new IllegalArgumentException("Unknown request " + requestId));
        }
        if (!this._serverGuidByRequestId.compareAndSet(pair, null)) {
            return Promises.reject((Exception)new IllegalArgumentException("Unknown request " + requestId));
        }
        return this.doLoginPair(pairSetup, provider -> provider.loginWith(bearerToken, loginData));
    }

    private <T extends ServersView> Promise<T> doLoginPair(PairSetup<?> pairSetup, Function<TokenProvider, Promise<SamlToken>> loginFunc) {
        if (!(pairSetup instanceof PairSetupImpl)) {
            return Promises.reject((Exception)new IllegalArgumentException("pairSetup"));
        }
        PairSetupImpl psImpl = (PairSetupImpl)pairSetup;
        Callable<Promise> call = () -> psImpl.getComplete().materialize().thenCompose(result -> {
            if (result.isSuccessful()) {
                return Promises.resolve((Object)this._currentView);
            }
            Exception err = result.getError();
            Throwable cause = err.getCause();
            if (!ProviderNotAuthenticatedException.class.isInstance(cause)) {
                return Promises.reject((Exception)new Topology.LoginFailedException(err));
            }
            TokenProvider provider = ((ProviderNotAuthenticatedException)((Object)((Object)((Object)cause)))).getProvider();
            return ((Promise)loginFunc.apply(provider)).materialize().thenCompose(pr -> {
                if (pr.isSuccessful()) {
                    return Promises.resolve((Object)this.doRefresh());
                }
                if (pr.getError() instanceof TokenProvider.InvalidCredentialsException) {
                    return Promises.reject((Exception)new Topology.LoginFailedException(pr.getError()));
                }
                if (pr.getError() instanceof TokenProvider.AcquireTokenFailed) {
                    return Promises.reject((Exception)new Topology.LoginFailedException((Exception)pr.getError().getCause()));
                }
                return Promises.reject((Exception)pr.getError());
            });
        });
        return this.executeInOwnContext(call);
    }

    public void destroy() {
        Callable<Void> call = () -> {
            if (this._disposed.compareAndSet(false, true)) {
                Future<?> nextTask = this._nextTimerTask.get();
                if (nextTask != null) {
                    nextTask.cancel(false);
                }
                this._viewBuilder.dispose();
            }
            return null;
        };
        this.executeInOwnContext(call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServersView doRefresh() {
        Object object = this._viewLock;
        synchronized (object) {
            this._currentView = this._viewBuilder.startBuildView();
        }
        this.scheduleNextRefreshTask();
        return this._currentView;
    }

    private void scheduleNextRefreshTask() {
        if (this._disposed.get()) {
            return;
        }
        ScheduledFuture<ServersView> next = SCHEDULED_EXEC.schedule(new RefreshTask(this), 300L, TimeUnit.SECONDS);
        Future<?> current = this._nextTimerTask.get();
        if (current != null) {
            current.cancel(false);
        }
        if (!this._nextTimerTask.compareAndSet(current, next) || this._disposed.get()) {
            next.cancel(false);
        }
    }

    private <T> T executeInOwnContext(Callable<T> exec) {
        try {
            return (T)ThreadContext.setupContext(exec, (ThreadContext)this._context);
        }
        catch (Exception e) {
            throw Exceptions.getRuntimeException(e);
        }
    }

    private static class RefreshTask
    implements Callable<ServersView> {
        private final WeakReference<TopologyImpl> _ref;

        private RefreshTask(TopologyImpl topology) {
            this._ref = new WeakReference<TopologyImpl>(topology);
        }

        @Override
        public ServersView call() {
            TopologyImpl topology = (TopologyImpl)this._ref.get();
            if (topology == null) {
                return null;
            }
            return topology.doRefresh();
        }
    }
}

