/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.Disposable;
import com.vmware.srm.client.topology.impl.sso.DrSecurityTokenService;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.exception.AuthenticationFailedException;
import com.vmware.vim.vmomi.core.Stub;
import java.security.PrivateKey;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenProviderImpl
implements TokenProvider,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenProviderImpl.class);
    private final AtomicReference<DrSecurityTokenService> _stsRef = new AtomicReference<Object>(null);
    private final AtomicBoolean _disposed = new AtomicBoolean(false);

    @Override
    public Promise<SamlToken> getToken() {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            return Promises.reject((Exception)new IllegalStateException("sts"));
        }
        return this.getToken(sts);
    }

    private Promise<SamlToken> getToken(DrSecurityTokenService sts) {
        return Promises.from(() -> SsoFacade.getTokenManager().getCurrentTokenFor(sts)).thenApply(token -> {
            if (token == null) {
                throw new TokenProvider.AuthenticationTokenNotAvailable(sts.getUrl());
            }
            return token;
        });
    }

    protected Promise<SamlToken> doLogin(Function<DrSecurityTokenService, Promise<SamlToken>> loginFunc) {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            return Promises.reject((Exception)new IllegalStateException("sts"));
        }
        return loginFunc.apply(sts).materialize().thenApply(pr -> {
            if (this._stsRef.get() != sts) {
                SsoFacade.getTokenManager().releaseToken(sts);
                throw new RuntimeException(this + " is disposed or STS changed.");
            }
            if (pr.getError() != null) {
                Exception e = pr.getError();
                LOGGER.warn("Failed to acquire token by credentials", (Throwable)e);
                if (e instanceof AuthenticationFailedException) {
                    throw new TokenProvider.InvalidCredentialsException(e);
                }
                throw new TokenProvider.AcquireTokenFailed(sts.getUrl(), (Throwable)e);
            }
            return (SamlToken)pr.getResult();
        });
    }

    @Override
    public Promise<SamlToken> loginWith(String username, String password) {
        return this.doLogin(stsClient -> Promises.from(() -> SsoFacade.getTokenManager().acquireToken((SecurityTokenService)stsClient, username, password)));
    }

    @Override
    public Promise<SamlToken> loginWith(SamlToken suToken, SamlToken actAsToken) {
        return this.doLogin(stsClient -> Promises.from(() -> SsoFacade.getTokenManager().acquireImpersonatingToken((SecurityTokenService)stsClient, suToken, actAsToken)));
    }

    @Override
    public Promise<SamlToken> acquireDelegatedToken(String delegateTo) {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            return Promises.reject((Exception)new IllegalStateException("sts"));
        }
        return Promises.from(() -> SsoFacade.getTokenManager().acquireDelegatedToken(sts, delegateTo)).thenApply(token -> {
            if (token == null) {
                throw new TokenProvider.AuthenticationTokenNotAvailable(sts.getUrl());
            }
            return token;
        });
    }

    @Override
    public Promise<SamlToken> acquireBearerToken() {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            return Promises.reject((Exception)new IllegalStateException("sts"));
        }
        return Promises.from(() -> SsoFacade.getTokenManager().acquireBearerToken(sts)).thenApply(token -> {
            if (token == null) {
                throw new TokenProvider.AuthenticationTokenNotAvailable(sts.getUrl());
            }
            return token;
        });
    }

    @Override
    public <T extends ManagedObject> Promise<T> createLoginStub(T stub) {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            return Promises.reject((Exception)new IllegalStateException("sts"));
        }
        return this.getToken(sts).thenApply(token -> {
            VlsiClientUtils.setAuthenticationData((Stub)stub, token, sts.getPrivateKey());
            return stub;
        });
    }

    @Override
    public Promise<ExecutionContext.SecurityContext> createSecurityContext() {
        this.checkIfDisposed();
        DrSecurityTokenService sts = this._stsRef.get();
        if (sts == null) {
            return Promises.reject((Exception)new IllegalStateException("sts"));
        }
        return this.getToken(sts).thenApply(token -> SecurityContextFactory.createSamlSecurityContext((SamlToken)token, (PrivateKey)sts.getPrivateKey()));
    }

    public void setSts(DrSecurityTokenService sts) {
        Validate.notNull((Object)sts, (String)"sts");
        this.checkIfDisposed();
        DrSecurityTokenService prev = this._stsRef.getAndSet(sts);
        if (prev != null) {
            this.disposeSts(prev);
        }
        if (this._disposed.get()) {
            this.disposeSts(sts);
            this.checkIfDisposed();
        }
    }

    public DrSecurityTokenService getSts() {
        return this._stsRef.get();
    }

    public void dispose() {
        if (this._disposed.getAndSet(true)) {
            return;
        }
        DrSecurityTokenService sts = this._stsRef.getAndSet(null);
        if (sts != null) {
            this.disposeSts(sts);
        }
    }

    private void checkIfDisposed() {
        if (this._disposed.get()) {
            throw new RuntimeException(this + " is disposed.");
        }
    }

    private void disposeSts(DrSecurityTokenService sts) {
        try {
            SsoFacade.getTokenManager().releaseToken(sts);
        }
        catch (Exception exc) {
            LOGGER.warn("Failed to dispose '{}'", (Object)sts, (Object)exc);
        }
        finally {
            sts.dispose();
        }
    }
}

