#!/bin/sh -e
# This script generates client stubs (proxy code) from the SRM WSDL and then
# compiles the client sample applications.
#
# To compile the client applications without re-generating the client stubs,
# pass the -w as an argument to the script.  For example:
# ./build.sh -w
#
# Note that this batchfile requires you to set two environment
# variables:
#   AXISHOME
#   JAVAHOME
#
# See the Developer's Setup Guide for more information about AXISHOME and
# JAVAHOME.  Alternatively, you can modify the settings of these two variables
# in the batchfile.  Be careful if you do so.
#

SAMPLEDIR=.
SAMPLEJARDIR=.

if [ "${AXISHOME}" == "" ] ; then
    echo "AXISHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "${JAVAHOME}" == "" ] ; then
    echo "JAVAHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "x$1" != "x-w" ] ; then
    WSDLFILESRM="../../../../wsdl/srm/srm-Service.wsdl"
fi

PATH="${JAVAHOME}/bin:${AXISHOME}/bin:${PATH}"
export PATH

# Clean up classpath (only include JAR files we actually need)
LOCALCLASSPATH="${PWD}:${AXISHOME}/lib/axis-ant.jar:${AXISHOME}/lib/commons-logging-1.0.4.jar:${AXISHOME}/lib/saaj.jar:${AXISHOME}/lib/axis.jar:${AXISHOME}/lib/jaxrpc.jar:${AXISHOME}/lib/wsdl4j-1.5.1.jar:${AXISHOME}/lib/commons-discovery-0.2.jar:${AXISHOME}/lib/log4j-1.2.8.jar"
LOCALCLASSPATH="${LOCALCLASSPATH}:${CLASSPATH}"

./clean.sh $1

cd ${SAMPLEDIR}

if [ "x$1" != "x-w" ] ; then
    rm -rf 'com/vmware/srm'
    mkdir -p 'com/vmware/srm'

    echo "Generating stubs from WSDL"
    java -Xms512M -Xmx1024M -Xss512k -classpath "${LOCALCLASSPATH}" org.apache.axis.wsdl.WSDL2Java -w -O-1 -p com.vmware.srm -o. ${WSDLFILESRM}

    echo "Compiling stubs."
    javac -J-Xms512M -J-Xmx512M -classpath "${LOCALCLASSPATH}" com/vmware/srm/*.java

    jar cf "${SAMPLEJARDIR}/srm.jar" com/vmware/srm/*.class
    echo "Done compiling stubs."

fi

echo "Compiling sample utilities"
javac -classpath "${LOCALCLASSPATH}" com/vmware/samples/srm/*.java
jar cf "${SAMPLEJARDIR}/apputils.jar" com/vmware/samples/srm/*.class

echo "Done compiling apputil"

echo "Compiling samples"
javac -classpath "${LOCALCLASSPATH}" com/vmware/samples/recovery/*.java
jar cf "${SAMPLEJARDIR}/samples.jar" com/vmware/samples/recovery/*.class

echo "Done."
