/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings.client;

import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.util.Validate;

public interface RetryPolicy {
    public RetrySpec onInvocationError(RuntimeException var1, RetryContext var2, int var3);

    public static final class RetrySpec {
        private final InvocationConfig invocationConfig;

        public RetrySpec(InvocationConfig invocationConfig) {
            this.invocationConfig = invocationConfig;
        }

        public InvocationConfig getInvocationConfig() {
            return this.invocationConfig;
        }
    }

    public static final class RetryContext {
        private final String serviceId;
        private final String operationId;
        private final ExecutionContext executionContext;
        private final StructValue input;

        public RetryContext(String serviceId, String operationId, ExecutionContext executionContext, StructValue input) {
            Validate.notEmpty(serviceId);
            Validate.notEmpty(operationId);
            Validate.notNull(executionContext);
            Validate.notNull(input);
            this.serviceId = serviceId;
            this.operationId = operationId;
            this.executionContext = executionContext;
            this.input = input;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getOperationId() {
            return this.operationId;
        }

        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        public StructValue getInput() {
            return this.input;
        }
    }
}

