/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeStorageProfileMapping;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.impex.utils.Lookup;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.pbm.profile.Profile;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProfileMappingsConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageProfileMappingsConverter.class);

    public static IeStorageProfileMapping[] fromVmodl(InventoryMapperBase.StorageProfileMapping[] mappings, Profile[] pairedProfiles, Profile[] localProfiles) {
        if (ArrayUtils.isEmpty((Object[])mappings)) {
            return new IeStorageProfileMapping[0];
        }
        Map<String, String> pairedProfileIdToName = GroupUtil.buildProfileIdToName(pairedProfiles);
        Map<String, String> localProfileIdToName = GroupUtil.buildProfileIdToName(localProfiles);
        return (IeStorageProfileMapping[])Arrays.stream(mappings).map(mapping -> {
            String primaryName = StorageProfileMappingsConverter.getProfileName(mapping.primaryObject.profileId, localProfileIdToName, true);
            String secondaryName = StorageProfileMappingsConverter.getProfileName(mapping.secondaryObject.profileId, pairedProfileIdToName, false);
            if (Objects.isNull(primaryName) || Objects.isNull(secondaryName)) {
                return null;
            }
            return new IeStorageProfileMapping(primaryName, secondaryName);
        }).filter(Objects::nonNull).toArray(IeStorageProfileMapping[]::new);
    }

    private static String getProfileName(String profileId, Map<String, String> profileIdToName, boolean primary) {
        if (!profileIdToName.containsKey(profileId)) {
            LOGGER.warn("Could not find name of {} profile id: '{}'.", (Object)(primary ? "primary" : "secondary"), (Object)profileId);
            return null;
        }
        return profileIdToName.get(profileId);
    }

    public static InventoryMapperBase.StorageProfileMapping[] toVmodl(IeStorageProfileMapping[] ieMappings, String localVcGuid, String pairVcGuid, Profile[] localProfiles, Profile[] remoteProfiles) {
        if (ArrayUtils.isEmpty((Object[])ieMappings)) {
            return new InventoryMapperBase.StorageProfileMapping[0];
        }
        return (InventoryMapperBase.StorageProfileMapping[])Arrays.stream(ieMappings).filter(Objects::nonNull).map(ieMapping -> StorageProfileMappingsConverter.toStorageProfileMapping(ieMapping, localVcGuid, pairVcGuid, StorageProfileMappingsConverter.buildProfilesWrapper(localProfiles), StorageProfileMappingsConverter.buildProfilesWrapper(remoteProfiles), localProfiles, remoteProfiles)).filter(Objects::nonNull).toArray(InventoryMapperBase.StorageProfileMapping[]::new);
    }

    private static ProfilesLookup buildProfilesWrapper(Profile[] profiles) {
        Map<String, String> nameToUid = Arrays.stream(profiles).collect(Collectors.toMap(profile -> profile.name, profile -> profile.profileId.uniqueId));
        return new ProfilesLookup(nameToUid);
    }

    private static InventoryMapperBase.StorageProfileMapping toStorageProfileMapping(IeStorageProfileMapping ieMapping, String localVcGuid, String pairVcGuid, ProfilesLookup localLookup, ProfilesLookup remoteLookup, Profile[] localProfiles, Profile[] remoteProfiles) {
        boolean secondaryIsPresent;
        boolean primaryIsPresent;
        String primaryName = ieMapping.getPrimary();
        if (primaryName == null) {
            LOGGER.warn("Invalid local storage policy.");
            return null;
        }
        String secondaryName = ieMapping.getSecondary();
        if (secondaryName == null) {
            LOGGER.warn("Invalid remote storage policy.");
            return null;
        }
        String primaryId = (String)localLookup.get(primaryName);
        if (primaryId == null) {
            LOGGER.warn("Local storage policy {} not found.", (Object)primaryName);
            return null;
        }
        String secondaryId = (String)remoteLookup.get(secondaryName);
        if (secondaryId == null) {
            LOGGER.warn("Remote storage policy {} not found.", (Object)secondaryName);
            return null;
        }
        boolean bl = primaryIsPresent = ArrayUtils.isNotEmpty((Object[])localProfiles) && Arrays.stream(localProfiles).anyMatch(profile -> primaryId.equals(profile.profileId.uniqueId));
        if (!primaryIsPresent) {
            LOGGER.warn("Local storage policy with name '{}' and id '{}' not present.", (Object)primaryName, (Object)primaryId);
            return null;
        }
        boolean bl2 = secondaryIsPresent = ArrayUtils.isNotEmpty((Object[])remoteProfiles) && Arrays.stream(remoteProfiles).anyMatch(profile -> secondaryId.equals(profile.profileId.uniqueId));
        if (!secondaryIsPresent) {
            LOGGER.warn("Remote storage policy with name '{}' and id '{}' not present.", (Object)secondaryName, (Object)secondaryId);
            return null;
        }
        InventoryMapperBase.StorageProfile primaryProfile = new InventoryMapperBase.StorageProfile(primaryId, localVcGuid);
        InventoryMapperBase.StorageProfile secondaryProfile = new InventoryMapperBase.StorageProfile(secondaryId, pairVcGuid);
        LOGGER.info("Adding storage profile mapping with names {} {}.", (Object)primaryName, (Object)secondaryName);
        return new InventoryMapperBase.StorageProfileMapping(primaryProfile, secondaryProfile, null);
    }

    private static class ProfilesLookup
    extends Lookup<String, String> {
        ProfilesLookup(Map<String, String> nameToId) {
            super(nameToId);
        }
    }
}

