/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.utilities.ContextApplier;
import com.vmware.dr.ui.tools.utilities.ContextApplierImpl;
import com.vmware.dr.ui.tools.utilities.ThreadContext;
import com.vmware.srm.client.impex.configurables.InventoryNames;
import com.vmware.srm.client.impex.tool.ConfigurablesWrapper;
import com.vmware.srm.client.impex.tool.InventoryUtil;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.impex.utils.SrmTaskMonitorImpl;
import com.vmware.srm.client.impex.utils.TaskMonitor;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrFault;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.impl.DrFaultImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.Validate;

public class ImpexImportSrmContext {
    private static final ThreadLocal<ImpexImportSrmContext> IMPEX_CONTEXT = new ThreadLocal();
    private final ImpexImportConfig _importConfig;
    private final SrmServersDataWrapper _serversDataWrapper;
    private final ConfigurablesWrapper _configurablesWrapper;
    private final InventoryNames _inventoryNames;
    private final List<DrFault> _errors;
    private final TaskMonitor _taskMonitor;

    public static <T> T executeWith(Callable<T> task, ImpexImportConfig importConfig, SrmServersDataWrapper serversWrapper, ConfigurablesWrapper configurablesWrapper) throws Exception {
        ImpexImportSrmContext context = new ImpexImportSrmContext(importConfig, serversWrapper, configurablesWrapper);
        return (T)ThreadContext.extendContext(task, (ContextApplier)new ContextApplierImpl(IMPEX_CONTEXT, (Object)context));
    }

    public static ImpexImportSrmContext get() {
        ImpexImportSrmContext impexContext = IMPEX_CONTEXT.get();
        Validate.notNull((Object)impexContext, (String)"impexContext");
        return impexContext;
    }

    public static boolean isAvailable() {
        return IMPEX_CONTEXT.get() != null;
    }

    private ImpexImportSrmContext(ImpexImportConfig importConfig, SrmServersDataWrapper serversDataWrapper, ConfigurablesWrapper configurablesWrapper) {
        if (configurablesWrapper.getData().size() == 0) {
            throw new InvalidFileException(ImpexL10N.localize("readFile.invalidFile", new Object[0]));
        }
        this._importConfig = importConfig;
        this._serversDataWrapper = serversDataWrapper;
        this._configurablesWrapper = configurablesWrapper;
        this._inventoryNames = InventoryUtil.getInventoryNames(configurablesWrapper);
        this._errors = new CopyOnWriteArrayList<DrFault>();
        this._taskMonitor = new SrmTaskMonitorImpl(serversDataWrapper.getView());
    }

    public ImpexImportConfig getImportConfig() {
        return this._importConfig;
    }

    public SrmServersDataWrapper getServersDataWrapper() {
        return this._serversDataWrapper;
    }

    public ConfigurablesWrapper getConfigurablesWrapper() {
        return this._configurablesWrapper;
    }

    public InventoryNames names() {
        return this._inventoryNames;
    }

    public void addError(String message) {
        Validate.notNull((Object)message);
        this._errors.add((DrFault)DrFaultImpl.from((String)message));
    }

    public void addError(String message, Exception error) {
        Validate.notNull((Object)message);
        this._errors.add((DrFault)DrFaultImpl.from((String)message, (Exception)error));
    }

    public List<DrFault> getErrors() {
        return new ArrayList<DrFault>(this._errors);
    }

    public List<DrFault> getAndResetErrors() {
        ArrayList<DrFault> result = new ArrayList<DrFault>(this._errors);
        this._errors.clear();
        return result;
    }

    public <T> Promise<T> monitor(ManagedObjectReference taskRef) {
        return ImpexImportSrmContext.get()._taskMonitor.monitor(taskRef);
    }

    static class InvalidFileException
    extends RuntimeException {
        InvalidFileException(String message) {
            super(message);
        }
    }

    public static class ImpexImportConfig {
        private final int _retriesDelay;
        private final int _retriesCount;
        private final boolean _allowOverrideProtectionSettings;

        public ImpexImportConfig(int retriesDelay, int retriesCount, boolean allowOverrideProtectionSettings) {
            this._retriesDelay = retriesDelay;
            this._retriesCount = retriesCount;
            this._allowOverrideProtectionSettings = allowOverrideProtectionSettings;
        }

        public int getRetriesDelay() {
            return this._retriesDelay;
        }

        public int getRetriesCount() {
            return this._retriesCount;
        }

        public boolean allowOverrideProtectionSettings() {
            return this._allowOverrideProtectionSettings;
        }
    }
}

