@REM This batchfile generates client stubs
@REM (proxy code) from the DrConfig WSDL and then compiles
@REM the client sample applications.
@REM
@REM To compile the client applications without re-generating the client stubs,
@REM pass the -w as an argument to the script. For example:
@REM build -w
@REM
@REM Note that this batchfile requires you to set two environment
@REM variables:
@REM   AXIS2_HOME
@REM   JAVAHOME
@REM
@REM See the Developer's Setup Guide for more information about
@REM AXIS2_HOME and JAVAHOME.
@REM Alternatively, you can modify the settings of
@REM these three variables in the batchfile. Be careful if you do so.
@REM


@echo off

setlocal
set SAMPLEDIR=.
set SAMPLEJARDIR=.

if NOT DEFINED AXIS2_HOME (
   @echo AXIS2_HOME not defined. Must be defined to build web service apps.
   goto END
)

if NOT DEFINED JAVAHOME (
   @echo JAVAHOME not defined. Must be defined to build java apps.
   goto END
)

if NOT "x%1" == "x-w" (
   set WSDLFILECONFIG=..\..\..\..\wsdl\drconfig\drconfig-service.wsdl
)

:SETENV
set PATH=%JAVAHOME%\bin;%AXIS2_HOME%\bin;%PATH%

set LOCALCLASSPATH=%CD%

for %%f in (%AXIS2_HOME%\lib\*.jar) do (call set LOCALCLASSPATH=%%LOCALCLASSPATH%%;%%f)

for %%i in ("lib\*.jar") do call lcp.bat %CD%\%%i

set LOCALCLASSPATH=%LOCALCLASSPATH%%CLASSPATH%

:DOBUILD
call clean.bat %1

cd %SAMPLEDIR%

if NOT "x%1" == "x-w" (

   @echo Generating stubs from wsdl
   java -Xms512M -Xmx1024M -Xss512k -classpath "%LOCALCLASSPATH%" org.apache.axis2.wsdl.WSDL2Java -d adb -p com.vmware.drconfig -ns2p urn:drConfig0=com.vmware.drconfig,urn:vim25=com.vmware.vim25 -u -or -o .\ -S .\ -uri %WSDLFILECONFIG%

   @echo Compiling stubs.
   javac -J-Xms512M -J-Xmx512M -classpath "%LOCALCLASSPATH%" com\vmware\drconfig\*.java

   javac -J-Xms512M -J-Xmx512M -classpath "%LOCALCLASSPATH%" com\vmware\vim25\*.java

   jar cf %SAMPLEJARDIR%\vim25.jar com\vmware\vim25\*.class

   jar cf %SAMPLEJARDIR%\drconfig.jar com\vmware\drconfig\*.class

   @echo Deleting temporary files
   del /q/f com\vmware\drconfig\*.class
   del /q/f com\vmware\vim25\*.class

   @echo Done compiling stubs.
)

@echo Compiling sample utilities
javac -classpath "%LOCALCLASSPATH%" com\vmware\samples\connection\*.java
jar cf %SAMPLEJARDIR%\apputils.jar com\vmware\samples\connection\*.class

@echo Done compiling apputil

@echo Compiling samples
javac -classpath "%LOCALCLASSPATH%" com\vmware\samples\drconfig\*.java
jar cf %SAMPLEJARDIR%\samples.jar com\vmware\samples\drconfig\*.class

:END
@echo Done.
@echo on
