/* **********************************************************
 * Copyright (c) 2020 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 * **********************************************************/
package com.vmware.samples.drconfig;

import java.net.URL;

/**
 * This class encapsulates configuration data (from the command-line) required
 * to run the sample application.
 */
public class BaseOptions {

   ////////////////////////////////////////////////////////////////////////////
   // Inner classes:
   ////////////////////////////////////////////////////////////////////////////

   /**
    * Thrown to indicate that the user has given invalid or unusable
    * command-line arguments.
    */
   public static class InvalidCliArgumentException
      extends java.lang.Exception {

      /**
       * Generated ID for object serialization.
       * @see java.io.Serializable
       */
      private static final long serialVersionUID = -7094364368235844645L;

      /**
       * Constructs an {@code InvalidCliArgumentException} with the specified
       * detail message.
       *
       * @param msg The detail message.
       */
      public InvalidCliArgumentException(final String msg) {
         super(msg);
      }

      /**
       * Constructs a new exception with the specified detail message and cause.
       * <p>
       * Note that the detail message associated with {@code cause} is
       * <em>not</em> automatically incorporated in this exception's detail
       * message.
       *
       * @param msg   The detail message (which is saved for later retrieval by
       *    the {@link Throwable#getMessage()} method.
       * @param cause The cause (which is saved for later retrieval by the
       *    {@link Throwable#getCause()} method).  (A {@code null} value is
       *    permitted, and indicates that the cause is nonexistent or unknown.)
       */
      public InvalidCliArgumentException(
         final String msg, final Throwable cause) {
         super(msg, cause);
      }
   }

   /**
    * Thrown to indicate that command-line processing has stopped, and a help
    * message should be displayed.
    */
   public static final class ShowHelpThrowable
      extends java.lang.Throwable {

      /**
       * Generated ID for object serialization.
       * @see java.io.Serializable
       */
      private static final long serialVersionUID = -8353364258918139617L;
   }

   ////////////////////////////////////////////////////////////////////////////
   // Public data:
   ////////////////////////////////////////////////////////////////////////////

   /** The user has requested to ignore SSL certificates in DrConfig connections. */
   public final boolean _ignoreCert;

   /** Address of the virtual appliance Example - https://<Virtual Appliance Address>:5480/... **/
   public final URL _vaAddress;

   /** Virtual Appliance user name. */
   public final String _vaUserName;

   /** Virtual Appliance password. */
   public final String _vaPassword;

   /** Operation - configure, clear, readCurrentConfig **/
   public final String _option;

   ////////////////////////////////////////////////////////////////////////////
   // Interface:
   ////////////////////////////////////////////////////////////////////////////

   /**
    * Construct a container for the generic sample.
    */
   public BaseOptions(
      final URL     vaAddress,
      final String  vaUserName,
      final String  vaPassword,
      final boolean ignoreCert,
      final String option)
   {
      _ignoreCert = ignoreCert;
     _vaAddress = vaAddress;
     _vaUserName = vaUserName;
     _vaPassword = vaPassword;
     _option = option;
   }

}
