#!/bin/sh -e
# This script generates JAXWS client stubs (proxy code) from the DrConfig WSDL and
# then compiles the client sample applications.
#
# To compile the client applications without re-generating the client stubs,
# pass the -w as an argument to the script. For example:
# build -w
#
# Note that this batchfile requires you to set environment
# variable:
#   JAVAHOME
#
# See the Developer's Setup Guide for more information about JAVAHOME.
#
# Alternatively, you can modify the settings of these three variables in the
# script.  Be careful if you do so.
#


SAMPLEDIR=.
SAMPLEJARDIR=.

if [ "${JAVAHOME}" == "" ] ; then
    echo "JAVAHOME not defined.  Must be defined to run java apps.">&2
    exit 2
fi

if [ "x$1" != "x-w" ] ; then
    WSDLDRCONFIG=drconfig-service.wsdl
    WSDLLOCATION=../../../wsdl/drconfig
fi

PATH="${JAVAHOME}/bin:${PATH}"
export PATH

LOCALCLASSPATH=${PWD}

./clean.sh $1

cd ${SAMPLEDIR}

echo "Building JAXWS stub optimization utility"
if [ -f FixJaxWsWsdlResource.class ] ; then
    rm -f FixJaxWsWsdlResource.class
fi
javac FixJaxWsWsdlResource.java

if [ "x$1" != "x-w" ] ; then
    rm -rf com/vmware/drconfig
    mkdir -p com/vmware/drconfig

    cp -a ${WSDLLOCATION}/* .
    cp -a ${WSDLLOCATION}/* com/vmware/drconfig

    echo "Generating stubs from wsdl"
    wsimport -wsdllocation ${WSDLDRCONFIG} -b jaxb-customizations.xjb -b ws-customizations.xml -s . ${WSDLDRCONFIG}

    echo "Compiling stubs."
    jar cf ${SAMPLEJARDIR}/vim25.jar com/vmware/vim25/*.class

    # fix DrConfigService class to get the wsdl from the drconfig.jar
    java -classpath "${LOCALCLASSPATH}" FixJaxWsWsdlResource "${PWD}/com/vmware/drconfig/DrConfigService.java"
    rm -f com/vmware/drconfig/DrConfigService.class
    javac -classpath "${LOCALCLASSPATH}:${SAMPLEJARDIR}/drconfig.jar" com/vmware/drconfig/DrConfigService.java

    jar cf ${SAMPLEJARDIR}/drconfig.jar com/vmware/drconfig/*.class com/vmware/drconfig/*.wsdl com/vmware/drconfig/*.xsd

    rm -f ./*.wsdl
    rm -f ./*.xsd
    rm -f com/vmware/drconfig/*.wsdl
    rm -f com/vmware/drconfig/*.xsd
    rm -f com/vmware/drconfig/*.class

    echo "Done compiling stubs."
fi

echo "Compiling samples"

javac -classpath "${LOCALCLASSPATH}:${SAMPLEJARDIR}/samples.jar" com/vmware/samples/connection/*.java com/vmware/samples/drconfig/*.java

jar cfm ${SAMPLEJARDIR}/samples.jar ./manifest-addition.txt com/vmware/samples/connection/*.class com/vmware/samples/drconfig/*.class

echo "Done."
