/* **********************************************************
 * Copyright (c) 2019-2020 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 * **********************************************************/
package com.vmware.samples.drconfig;

import java.io.Console;

/**
 * Helper class that uses the default console. Meaning if we are running
 * in an IDE (like Eclipse) it will use it's console. If not,
 * we are running in CMD then we will use CMD as default console for input.
 */
public class ConsoleIOHelper implements IOHelper {

   private final Console _console;

   public ConsoleIOHelper(Console console) {
      _console = console;
   }

   @Override
   public void writeln(String message) {
      _console.writer().println(message);
   }

   @Override
   public String readln(String message) {
      write(message);
      String input = _console.readLine();
      return input;
   }

   @Override
   public String readPass(String message) {
      write(message);
      return new String(_console.readPassword());
   }

   @Override
   public String readln() {
      return this.readln("");
   }

   private void write(String message) {
      _console.writer().write(message);
      _console.writer().flush();
   }
}
