import java.io.*;

public class FixJaxWsWsdlResource {

   private static final String GETRESOURCE = "SrmService.class.getResource(\".\");";
   private static final String RES_PART = "\".\"";

   private static final String REPLACE_STRING = "SrmService.class.getSimpleName() + \".class\"";

   /**
    * Replaces the "." in getResource with a class reference so the wsdl files
    * can be found relative to the SrmServiceClass.
    *
    * @param srmServiceFilePath
    */
   private static void fixResourceLocation(String srmServiceFilePath) {
      File svcFile = null;
      File destSvcFile = null;
      BufferedReader svcClassReader = null;
      BufferedWriter svcClassWriter = null;

      boolean resourceReset = false;
      try {
         svcFile = new File(srmServiceFilePath);
         if (!svcFile.exists()) {
            System.out.println("SrmService file not found : " + srmServiceFilePath);
            return;
         }

         String destSvcFilePath = srmServiceFilePath + ".tmp";
         destSvcFile = new File(destSvcFilePath);
         if (destSvcFile.exists() && !destSvcFile.delete()) {
            System.out.println("Unable to delete temporary file : " + destSvcFilePath);
            return;
         }
         if (destSvcFile.createNewFile() && destSvcFile.setReadable(true) && destSvcFile.setWritable(true)) {
            svcClassReader = new BufferedReader(new FileReader(svcFile));
            svcClassWriter = new BufferedWriter(new FileWriter(destSvcFile));

            String line = null;
            do {
               line = svcClassReader.readLine();
               if (line != null) {
                  if (line.contains(GETRESOURCE)) {
                     // Replace "." with "SrmService.class.getSimpleName() + ".class"
                     line = line.replace(RES_PART, REPLACE_STRING);
                  }
                  svcClassWriter.write(line);
                  svcClassWriter.newLine();
               }
            } while (line != null);
            resourceReset = true;
         }
      } catch (IOException ioe) {
         System.out.println("Error reading SrmService file : " + srmServiceFilePath);
      } catch (Exception e) {
         System.out.println("Error reading SrmService file : " + srmServiceFilePath);
      } finally {
         try {
            if (svcClassReader != null) {
               svcClassReader.close();
            }
            if (svcClassWriter != null) {
               svcClassWriter.flush();
               svcClassWriter.close();
            }
            if (resourceReset) {
               svcFile.delete();
               destSvcFile.renameTo(svcFile);
            }
         } catch (IOException x) {
            // Do nothing
         }
      }
   }

   /**
    * @param args
    */
   public static void main(String[] args) {
      if (args == null || args.length == 0 || args.length != 1) {
         System.out.println("Usage: java FixJaxWsWsdlResource.class path/to/SrmService.java.\n   Fully Qualified Service class java file path required");
         return;
      }

      fixResourceLocation(args[0]);
   }

}
