@REM This batchfile generates JAXWS client stubs
@REM (proxy code) from the srm WSDL and then compiles
@REM the client sample applications.
@REM
@REM To compile the client applications without re-generating the client stubs,
@REM pass the -w as an argument to the script. For example:
@REM build -w
@REM
@REM Note that this batchfile requires you to set environment
@REM variable:
@REM   JAVAHOME
@REM
@REM See the Developer's Setup Guide for more information about
@REM JAVAHOME.
@REM Alternatively, you can modify the settings of
@REM these three variables in the batchfile. Be careful if you do so.
@REM


@echo off

setlocal
set SAMPLEDIR=.
set SAMPLEJARDIR=.

if NOT DEFINED JAVAHOME (
   @echo JAVAHOME not defined. Must be defined to build java apps.
   goto END
)

if NOT "x%1" == "x-w" (
   set WSDLSRM=srm-Service.wsdl
   set WSDLLOCATION=..\..\..\wsdl\srm
)

:SETENV
set PATH=%JAVAHOME%\bin;%PATH%

set LOCALCLASSPATH=%CD%

for %%i in ("lib\*.jar") do call lcp.bat %CD%\%%i

:DOBUILD
call clean.bat %1

cd %SAMPLEDIR%

@echo Building JAXWS stub optimization utility
@if not exist FixJaxWsWsdlResource.class goto BUILDJAXWSUTIL
del /q/f FixJaxWsWsdlResource.class

:BUILDJAXWSUTIL
javac FixJaxWsWsdlResource.java

if NOT "x%1" == "x-w" (
   IF EXIST com\vmware\srm (
      rmdir /s/q com\vmware\srm
   )
   mkdir com\vmware\srm

   xcopy /q/i/s %WSDLLOCATION%\*.* .
   xcopy /q/i/s %WSDLLOCATION%\*.* com\vmware\srm

   @echo Generating stubs from wsdl
   wsimport -wsdllocation %WSDLSRM% -b jaxb-customizations.xjb -b ws-customizations.xml -b vim-types.xsd -s . %WSDLSRM%

   @echo Compiling stubs.
   jar cf %SAMPLEJARDIR%\vim25.jar com\vmware\vim25\*.class

   @rem fix SrmService class to get the wsdl from the srm.jar
   java -classpath "%LOCALCLASSPATH%" FixJaxWsWsdlResource "%CD%\com\vmware\srm\SrmService.java"
   del /q/f com\vmware\srm\SrmService.class
   javac -classpath "%LOCALCLASSPATH%;%SAMPLEJARDIR%\vim25.jar" com\vmware\srm\SrmService.java

   jar cf %SAMPLEJARDIR%\srm.jar com\vmware\vim25\*.class com\vmware\srm\*.class com\vmware\srm\*.wsdl com\vmware\srm\*.xsd

   del /q/f .\*.wsdl
   del /q/f .\*.xsd
   del /q/f com\vmware\srm\*.wsdl
   del /q/f com\vmware\srm\*.xsd
   del /q/f com\vmware\srm\*.class
   del /q/f com\vmware\vim25\*.class

   @echo Done compiling stubs.
)

@echo Compiling samples

javac -classpath "%LOCALCLASSPATH%;%SAMPLEJARDIR%\srm.jar" com\vmware\samples\recovery\*.java com\vmware\samples\srm\*.java
if %ERRORLEVEL% neq 0 goto ABORT

jar cf %SAMPLEJARDIR%\samples.jar com\vmware\samples\recovery\*.class com\vmware\samples\srm\*.class

:END
@echo Done.

:ABORT
@echo on
