/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.vmomi.core.types.impl.VmodlContextLoader;
import com.vmware.vim.vmomi.core.types.impl.VmodlContextMetadata;
import com.vmware.vim.vmomi.core.util.ClassUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClassContextLoader {
    ClassContextLoader() {
    }

    static VmodlContextLoader load(String vmodlPackage) throws ClassNotFoundException, UnexpectedLoadFailure {
        String metadataClassName = vmodlPackage + ".$ContextMetadata";
        ClassLoader classLoader = ClassUtil.getCurrentClassLoader();
        Class<?> metadataClass = classLoader.loadClass(metadataClassName);
        VmodlContextMetadata metadata = ClassContextLoader.metadata(metadataClass);
        VmodlContextLoader loader = new VmodlContextLoader();
        loader.setHideMoRef(metadata.hideMoRef);
        loader.setWsdlNameContext(ClassContextLoader.mapFrom(metadata.wsdlNames, metadata.types));
        loader.setVmodlDataObjects(ClassContextLoader.mapFrom(metadata.dataObjectNames, metadata.dataObjectTypes));
        loader.setVmodlVersionContext(ClassContextLoader.vmodlVersionContext(metadata.versions), metadata.namespace);
        metadata.applyTo(loader);
        return loader;
    }

    private static VmodlContextMetadata metadata(Class<?> clazz) throws UnexpectedLoadFailure {
        try {
            return (VmodlContextMetadata)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnexpectedLoadFailure("Unable to instantiate " + clazz, e);
        }
    }

    static Map<String, String> mapFrom(String[] keys, String[] values) throws UnexpectedLoadFailure {
        if (keys == null || values == null) {
            return null;
        }
        int length = keys.length;
        if (values.length != length) {
            throw new UnexpectedLoadFailure("Keys and values differ in length");
        }
        HashMap<String, String> result = new HashMap<String, String>(ClassContextLoader.mapCapacity(length));
        for (int i = 0; i < length; ++i) {
            String key = keys[i];
            if (key == null || key.length() == 0) {
                throw new UnexpectedLoadFailure("Null or empty key at index " + i);
            }
            String value = values[i];
            if (value == null || value.length() == 0) {
                throw new UnexpectedLoadFailure("Null or empty value at index " + i);
            }
            if (result.put(key, value) == null) continue;
            throw new UnexpectedLoadFailure("Identical keys: " + keys[i]);
        }
        return result;
    }

    static List<Class<?>> vmodlVersionContext(String[] versions) throws ClassNotFoundException {
        if (versions == null) {
            return null;
        }
        int length = versions.length;
        ClassLoader classLoader = ClassUtil.getCurrentClassLoader();
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = classLoader.loadClass(versions[i]);
        }
        return Arrays.asList(classes);
    }

    private static int mapCapacity(int size) {
        if (size < 3) {
            return size + 1;
        }
        return (int)((float)size / 0.75f + 1.0f);
    }

    static class UnexpectedLoadFailure
    extends Exception {
        public UnexpectedLoadFailure(String message) {
            super(message);
        }

        public UnexpectedLoadFailure(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

