/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class HashGenerator {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int DEFAULT_TRUNCATE_LENGTH = 8;
    public static final int HASH_MAX_LEN = 128;
    private static MessageDigest _messageDigest;

    protected static synchronized char[] generate(String value) {
        if (value == null) {
            return null;
        }
        return Hex.encodeHex((byte[])_messageDigest.digest(value.getBytes(UTF8)));
    }

    public static String generate(String value, int length) {
        if (value == null) {
            return null;
        }
        if (length < 1 || length > 128) {
            throw new IndexOutOfBoundsException("Supported lengths are from 1 to 128 inclusive.");
        }
        char[] hex = HashGenerator.generate(value);
        return String.valueOf(hex, 0, length).toUpperCase();
    }

    public static String generateTruncated(String value) {
        return HashGenerator.generate(value, 8);
    }

    static {
        try {
            _messageDigest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error initializing the SHA512 hashing algorithm.", e);
        }
    }
}

