/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.util;

import com.vmware.vapi.cis.authn.json.JsonSignatureVerificationProcessor;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshableCache<T> {
    private static final Logger logger = LoggerFactory.getLogger(JsonSignatureVerificationProcessor.class);
    private final Supplier<T> supplier;
    private final long refreshTimeoutNs;
    private final Object lock = new Object();
    private volatile Holder cache;

    public RefreshableCache(Supplier<T> supplier, long refreshTimeoutMs) {
        if (refreshTimeoutMs < 0L) {
            throw new IllegalArgumentException("refreshTimeoutMs cannot be negative");
        }
        Objects.requireNonNull(supplier, "supplier cannot be null");
        this.supplier = supplier;
        this.refreshTimeoutNs = TimeUnit.MILLISECONDS.toNanos(refreshTimeoutMs);
        this.cache = new Holder(supplier.get());
    }

    public T get() {
        return this.cache.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.cache.refreshTimeoutExpired()) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.cache.refreshTimeoutExpired()) {
                    logger.trace("Using newly provisioned cache");
                    return;
                }
                logger.trace("Refreshing cache");
                this.cache = new Holder(this.supplier.get());
                return;
            }
        }
        logger.trace("Not refreshing cache. Timeout has not expired");
    }

    private class Holder {
        private final T value;
        private final long createdAt;

        Holder(T value) {
            this.value = value;
            this.createdAt = System.nanoTime();
        }

        boolean refreshTimeoutExpired() {
            long now = System.nanoTime();
            boolean canRefresh = now - this.createdAt > RefreshableCache.this.refreshTimeoutNs;
            return canRefresh;
        }

        T getValue() {
            return this.value;
        }
    }
}

