/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.af.interop;

import com.vmware.af.VmAfClientNativeException;
import com.vmware.af.interop.VmAfAccessDeniedException;
import com.vmware.af.interop.VmAfAlreadyJoinedException;
import com.vmware.af.interop.VmAfBadPacketException;
import com.vmware.af.interop.VmAfInvalidComputerNameException;
import com.vmware.af.interop.VmAfInvalidParameterException;
import com.vmware.af.interop.VmAfLdapNoSuchObjectException;
import com.vmware.af.interop.VmAfNoSuchDomainException;
import com.vmware.af.interop.VmAfNoSuchLogonSessionException;
import com.vmware.af.interop.VmAfNotJoinedException;
import com.vmware.af.interop.VmAfNotSupportedException;
import com.vmware.af.interop.VmAfUnknownServerException;
import com.vmware.af.interop.VmAfWrongPasswordException;
import com.vmware.af.interop.VmafErrors;
import java.util.HashMap;
import java.util.Map;

class VmAfClientAdapterErrorHandler {
    private static Map<Integer, Handler> errorCodeToHandler = new HashMap<Integer, Handler>();

    private VmAfClientAdapterErrorHandler() {
        throw new UnsupportedOperationException("not instantiable, use the static handleError method");
    }

    public static void handleErrorCode(int errorCode) {
        if (errorCode != 0) {
            Handler handler = errorCodeToHandler.get(errorCode);
            if (handler != null) {
                handler.handleError(errorCode);
            } else {
                throw new VmAfClientNativeException(errorCode);
            }
        }
    }

    static {
        errorCodeToHandler.put(VmafErrors.ERROR_ACCESS_DENIED.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfAccessDeniedException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.ERROR_NOT_SUPPORTED.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfNotSupportedException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.ERROR_INVALID_PARAMETER.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfInvalidParameterException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.ERROR_INVALID_COMPUTERNAME.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfInvalidComputerNameException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.ERROR_NO_SUCH_LOGON_SESSION.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfNoSuchLogonSessionException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.ERROR_WRONG_PASSWORD.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfWrongPasswordException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.ERROR_NO_SUCH_DOMAIN.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfNoSuchDomainException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.NERR_UNKNOWNSERVER.getErrorCode(), new Handler(){

            @Override
            public void handleError(int vmafErrorCode) throws VmAfClientNativeException {
                throw new VmAfUnknownServerException(vmafErrorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.NERR_SETUPALREADYJOINED.getErrorCode(), new Handler(){

            @Override
            public void handleError(int vmafErrorCode) throws VmAfClientNativeException {
                throw new VmAfAlreadyJoinedException(vmafErrorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.NERR_SETUPNOTJOINED.getErrorCode(), new Handler(){

            @Override
            public void handleError(int vmafErrorCode) throws VmAfClientNativeException {
                throw new VmAfNotJoinedException(vmafErrorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.ERROR_BAD_PACKET.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfBadPacketException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.LW_ERROR_PASSWORD_MISMATCH.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfWrongPasswordException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.LW_ERROR_LDAP_NO_SUCH_OBJECT.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfLdapNoSuchObjectException(errorCode);
            }
        });
        errorCodeToHandler.put(VmafErrors.LW_ERROR_KRB5KDC_ERR_C_PRINCIPAL_UNKNOWN.getErrorCode(), new Handler(){

            @Override
            public void handleError(int errorCode) throws VmAfClientNativeException {
                throw new VmAfNoSuchLogonSessionException(errorCode);
            }
        });
    }

    private static interface Handler {
        public void handleError(int var1) throws VmAfClientNativeException;
    }
}

