/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.reactive.impl;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.PromiseResult;
import com.vmware.dr.ui.tools.reactive.Subscriber;
import com.vmware.dr.ui.tools.reactive.Subscription;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.srm.client.reactive.impl.request.RequestContext;
import com.vmware.vim.vmomi.core.Future;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class FuturePromise<T>
implements Promise<T>,
Future<T> {
    private final PromiseImpl<T> _impl = new PromiseImpl();
    private final Promise<T> _bound;

    public FuturePromise() {
        RequestContext<?> context = RequestContext.getContext();
        this._bound = context == null ? this._impl : context.bind(this._impl);
    }

    public Promise<T> onSuccess(Consumer<T> resultConsumer) {
        return this._bound.onSuccess(resultConsumer);
    }

    public Promise<T> onError(Consumer<Exception> errorConsumer) {
        return this._bound.onError(errorConsumer);
    }

    public <U> Promise<U> thenCompose(Function<? super T, ? extends Promise<? extends U>> fn) {
        return this._bound.thenCompose(fn);
    }

    public <U> Promise<U> thenApply(Function<? super T, ? extends U> fn) {
        return this._bound.thenApply(fn);
    }

    public <U, V> Promise<V> thenCombine(Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this._bound.thenCombine(other, fn);
    }

    public <U, V> Promise<V> thenCombineCompose(Promise<? extends U> other, BiFunction<? super T, ? super U, ? extends Promise<? extends V>> fn) {
        return this._bound.thenCombineCompose(other, fn);
    }

    public Promise<PromiseResult<T>> materialize() {
        return this._bound.materialize();
    }

    public Subscription<T> subscribe(Subscriber<? super T> subscriber) {
        return this._bound.subscribe(subscriber);
    }

    public void set(T ret) {
        this._impl.setResult(ret);
    }

    public void set() {
        this._impl.setResult(null);
    }

    public void setException(Exception e) {
        this._impl.setError(e);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this._impl.setError((Exception)new CancellationException())) {
            return false;
        }
        AtomicReference<Object> cancelled = new AtomicReference<Object>(null);
        this._bound.materialize().onSuccess(pr -> cancelled.set((pr.getError() instanceof CancellationException)));
        while (cancelled.get() == null) {
            Thread.yield();
        }
        return cancelled.get();
    }

    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    public boolean isDone() {
        if (this._impl != this._bound) {
            throw new UnsupportedOperationException("Running with request context");
        }
        return this._impl.isComplete();
    }

    public T get() {
        throw new UnsupportedOperationException();
    }

    public T get(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }
}

