/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication.oauth2;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.infrastructure.authentication.AuthenticationUtils;
import com.vmware.srm.client.infrastructure.authentication.oauth2.BaseExchangeController;
import com.vmware.srm.client.infrastructure.authentication.oauth2.OAuth2AuthenticationStrategy;
import com.vmware.srm.client.infrastructure.init.InitFilter;
import com.vmware.srm.client.infrastructure.init.workflow.Configurator;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.vim.sso.client.SamlToken;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2LoginServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2LoginServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String errorCode = request.getParameter("error");
        if (errorCode != null) {
            LOGGER.error("OAuth2 response contains error: '{}'", (Object)errorCode);
            response.sendError(500);
            return;
        }
        String code = request.getParameter("code");
        Validate.notNull((Object)code, (String)"code");
        if (AuthenticationUtils.isAuthenticated(request)) {
            response.sendRedirect("/dr/");
            return;
        }
        Configurator configurator = InitFilter.getConfigurator(request);
        LoginExchangeController controller = new LoginExchangeController(request, response, code, configurator);
        controller.start(Config.get().getResponseTimeout());
    }

    private static class LoginExchangeController
    extends BaseExchangeController {
        protected LoginExchangeController(HttpServletRequest request, HttpServletResponse response, String authCode, Configurator configurator) {
            super(request, response, authCode, configurator);
        }

        @Override
        protected URI getRedirectUrl(OAuth2AuthenticationStrategy strategy) {
            return strategy.getAppRedirectUrl();
        }

        @Override
        protected Promise<Void> completeLoginRequestProcessing(OAuth2AuthenticationStrategy strategy, String redirectPath, SamlToken samlToken, String refreshToken) {
            return AuthenticationUtils.setupSession(strategy.getSsoContext(), strategy, null, samlToken, null, redirectPath, this._request, this._response);
        }
    }
}

