/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.Credentials;
import com.vmware.srm.client.infrastructure.authentication.SACredentialsManager;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.TokenProviderImpl;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.SsoFacade;
import com.vmware.srm.client.topology.impl.sso.TokenManager;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;

public class ServiceAccountTokenManager {
    private final SACredentialsManager _credentialsManager;
    private final TokenProviderImpl _provider = new ProviderImpl();

    public ServiceAccountTokenManager(Path saPath, LsppService ssoReg, LsppServiceEndpoint vapiEp) throws GeneralSecurityException, IOException {
        this._provider.setSts(SsoFacade.createSts((LsppService)ssoReg));
        this._credentialsManager = new SACredentialsManager(saPath, ssoReg, vapiEp);
    }

    public TokenProvider getTokenProvider() {
        return this._provider;
    }

    public void dispose() {
        this._provider.dispose();
    }

    private final class ProviderImpl
    extends TokenProviderImpl {
        private ProviderImpl() {
        }

        public Promise<SamlToken> getToken() {
            return super.getToken().materialize().thenCompose(pr -> {
                if (pr.isSuccessful()) {
                    return Promises.resolve((Object)((SamlToken)pr.getResult()));
                }
                Exception exc = pr.getError();
                if (exc instanceof TokenProvider.AuthenticationTokenNotAvailable) {
                    return ServiceAccountTokenManager.this._credentialsManager.getCredentials().thenCompose(this::acquireToken).materialize().thenCompose(nestedPr -> {
                        if (nestedPr.isSuccessful()) {
                            return Promises.resolve((Object)((SamlToken)nestedPr.getResult()));
                        }
                        Exception nestedExc = nestedPr.getError();
                        if (nestedExc instanceof TokenManager.TokenRequestExists) {
                            return this.getToken();
                        }
                        exc.addSuppressed(nestedExc);
                        return Promises.reject((Exception)exc);
                    });
                }
                return Promises.reject((Exception)exc);
            });
        }

        private Promise<SamlToken> acquireToken(Credentials credentials) {
            return Promises.from(() -> SsoFacade.getTokenManager().acquireToken((SecurityTokenService)this.getSts(), credentials.user, credentials.pass));
        }
    }
}

